/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer;

import de.gaalop.visualizer.Point3d;
import java.awt.Color;
import java.util.LinkedList;
import org.jdom.Content;
import org.jdom.Element;

public class PointCloud {
    public String name;
    public Color color;
    public LinkedList<Point3d> points;

    public PointCloud(String name, Color color, LinkedList<Point3d> points) {
        this.name = name;
        this.color = color;
        this.points = points;
    }

    public PointCloud(Element element) {
        this.name = element.getAttributeValue("name");
        this.color = new Color(Integer.parseInt(element.getAttributeValue("colorR")), Integer.parseInt(element.getAttributeValue("colorG")), Integer.parseInt(element.getAttributeValue("colorB")), Integer.parseInt(element.getAttributeValue("colorA")));
        this.points = new LinkedList();
        for (Object childObj : element.getChildren()) {
            Element child = (Element)childObj;
            this.points.add(new Point3d(Double.parseDouble(child.getAttributeValue("x")), Double.parseDouble(child.getAttributeValue("y")), Double.parseDouble(child.getAttributeValue("z"))));
        }
    }

    public Element toElement() {
        Element result = new Element("PointCloud");
        result.setAttribute("name", this.name);
        result.setAttribute("colorR", Integer.toString(this.color.getRed()));
        result.setAttribute("colorG", Integer.toString(this.color.getGreen()));
        result.setAttribute("colorB", Integer.toString(this.color.getBlue()));
        result.setAttribute("colorA", Integer.toString(this.color.getAlpha()));
        for (Point3d p : this.points) {
            Element pElement = new Element("p");
            pElement.setAttribute("x", Double.toString(p.x));
            pElement.setAttribute("y", Double.toString(p.y));
            pElement.setAttribute("z", Double.toString(p.z));
            result.addContent((Content)pElement);
        }
        return result;
    }
}

