/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.engines.lwjgl.recording;

import de.gaalop.visualizer.engines.lwjgl.LwJglRenderingEngine;
import de.gaalop.visualizer.engines.lwjgl.recording.AnimatedGifEncoder;
import de.gaalop.visualizer.engines.lwjgl.recording.Recorder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class GIFRecorder
extends Recorder {
    private AnimatedGifEncoder encoder;

    @Override
    public void _addFrame(BufferedImage image, long delay) {
        this.encoder.setDelay((int)delay);
        this.encoder.addFrame(image);
    }

    @Override
    public void _finish() {
        this.encoder.finish();
        System.out.println("Written recording");
    }

    @Override
    protected void _startRecording() {
        try {
            this.encoder = new AnimatedGifEncoder();
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.getName().toLowerCase().endsWith(".gif")) {
                        return true;
                    }
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "GIF files";
                }
            });
            if (chooser.showSaveDialog(null) == 0) {
                this.encoder.start(new FileOutputStream(chooser.getSelectedFile()));
                this.encoder.setDelay(40);
                System.out.println("Started recording");
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LwJglRenderingEngine.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

