/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.engines.lwjgl.recording;

import de.gaalop.visualizer.engines.lwjgl.recording.TransformationThread;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public abstract class Recorder {
    private long lastTime = -1L;
    private long curTime = -1L;
    private TransformationThread thread;

    public void makeScreenshot() {
        this.curTime = System.currentTimeMillis();
        ByteBuffer screenBuffer = ByteBuffer.allocateDirect(Display.getDisplayMode().getWidth() * Display.getDisplayMode().getHeight() * 3);
        try {
            GL11.glReadBuffer((int)1029);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glReadPixels((int)0, (int)0, (int)Display.getDisplayMode().getWidth(), (int)Display.getDisplayMode().getHeight(), (int)6407, (int)5121, (ByteBuffer)screenBuffer);
            long delay = this.lastTime == -1L ? 0L : this.curTime - this.lastTime;
            this.lastTime = this.curTime;
            this.thread.addFrame(screenBuffer, delay);
        }
        catch (Exception e) {
            System.out.println("Streaming exception.");
            e.printStackTrace();
        }
    }

    public abstract void _addFrame(BufferedImage var1, long var2);

    public void startRecording() {
        this.thread = new TransformationThread(this);
        this._startRecording();
        this.thread.start();
    }

    public void stopRecording() {
        System.out.println("Stopped recording");
        this.thread.terminate();
    }

    protected abstract void _startRecording();

    public abstract void _finish();
}

