/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.gui;

import de.gaalop.visualizer.gui.LabeledComponent;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public abstract class InputsPanel
implements ChangeListener {
    private JPanel panel;
    private HashMap<JSpinner, String> mapSpinners = new HashMap();

    public InputsPanel(JPanel panel) {
        this.panel = panel;
    }

    public void setInputs(LinkedList<String> inputs) {
        this.panel.removeAll();
        this.panel.setSize(this.panel.getWidth(), 25 * inputs.size());
        this.panel.setLayout(new GridLayout(inputs.size() < 8 ? 8 - inputs.size() : inputs.size(), 1, 5, 5));
        this.mapSpinners.clear();
        for (String input : inputs) {
            JSpinner spinner = new JSpinner(new SpinnerNumberModel());
            this.mapSpinners.put(spinner, input);
            this.panel.add(new LabeledComponent(input + ":", spinner));
            spinner.addChangeListener(this);
        }
    }

    public HashMap<String, Double> getValues() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (JSpinner spinner : this.mapSpinners.keySet()) {
            result.put(this.mapSpinners.get(spinner), ((Number)spinner.getValue()).doubleValue());
        }
        return result;
    }
}

