/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.gui;

import de.gaalop.dfg.Expression;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public abstract class VisiblePanel
implements ChangeListener {
    private JPanel panel;
    private HashMap<JCheckBox, String> boxes = new HashMap();

    public VisiblePanel(JPanel panel) {
        this.panel = panel;
    }

    public void setObjects(Set<String> names, HashMap<String, Expression> renderingExpressions) {
        this.panel.removeAll();
        this.panel.setSize(this.panel.getWidth(), 25 * names.size());
        this.panel.setLayout(new GridLayout(names.size() < 8 ? 8 - names.size() : names.size(), 1, 5, 5));
        this.boxes.clear();
        for (String input : names) {
            JCheckBox box = input.endsWith("_S") ? new JCheckBox(renderingExpressions.get(input.substring(0, input.length() - 2)).toString(), true) : new JCheckBox(renderingExpressions.get(input).toString());
            box.addChangeListener(this);
            this.boxes.put(box, input);
            this.panel.add(box);
        }
    }

    public HashSet<String> getVisibleObjects() {
        HashSet<String> result = new HashSet<String>();
        for (JCheckBox box : this.boxes.keySet()) {
            if (!box.isSelected()) continue;
            result.add(this.boxes.get(box));
        }
        return result;
    }
}

