/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.ia_math;

import de.gaalop.visualizer.ia_math.IAException;
import de.gaalop.visualizer.ia_math.RMath;
import de.gaalop.visualizer.ia_math.RealInterval;

public class IAMath {
    public static final boolean nonempty(RealInterval x) {
        return x.lo <= x.hi;
    }

    public static RealInterval intersect(RealInterval x, RealInterval y) throws IAException {
        return new RealInterval(Math.max(x.lo, y.lo), Math.min(x.hi, y.hi));
    }

    public static RealInterval union(RealInterval x, RealInterval y) throws IAException {
        return new RealInterval(Math.min(x.lo, y.lo), Math.max(x.hi, y.hi));
    }

    public static RealInterval add(RealInterval x, RealInterval y) {
        RealInterval z = new RealInterval();
        z.lo = RMath.add_lo(x.lo, y.lo);
        z.hi = RMath.add_hi(x.hi, y.hi);
        return z;
    }

    public static RealInterval sub(RealInterval x, RealInterval y) {
        RealInterval z = new RealInterval();
        z.lo = RMath.sub_lo(x.lo, y.hi);
        z.hi = RMath.sub_hi(x.hi, y.lo);
        return z;
    }

    public static RealInterval mul(RealInterval x, RealInterval y) {
        RealInterval z = new RealInterval();
        if (x.lo == 0.0 && x.hi == 0.0 || y.lo == 0.0 && y.hi == 0.0) {
            z.lo = 0.0;
            z.hi = RMath.NegZero;
        } else if (x.lo >= 0.0) {
            if (y.lo >= 0.0) {
                z.lo = Math.max(0.0, RMath.mul_lo(x.lo, y.lo));
                z.hi = RMath.mul_hi(x.hi, y.hi);
            } else if (y.hi <= 0.0) {
                z.lo = RMath.mul_lo(x.hi, y.lo);
                z.hi = Math.min(0.0, RMath.mul_hi(x.lo, y.hi));
            } else {
                z.lo = RMath.mul_lo(x.hi, y.lo);
                z.hi = RMath.mul_hi(x.hi, y.hi);
            }
        } else if (x.hi <= 0.0) {
            if (y.lo >= 0.0) {
                z.lo = RMath.mul_lo(x.lo, y.hi);
                z.hi = Math.min(0.0, RMath.mul_hi(x.hi, y.lo));
            } else if (y.hi <= 0.0) {
                z.lo = Math.max(0.0, RMath.mul_lo(x.hi, y.hi));
                z.hi = RMath.mul_hi(x.lo, y.lo);
            } else {
                z.lo = RMath.mul_lo(x.lo, y.hi);
                z.hi = RMath.mul_hi(x.lo, y.lo);
            }
        } else if (y.lo >= 0.0) {
            z.lo = RMath.mul_lo(x.lo, y.hi);
            z.hi = RMath.mul_hi(x.hi, y.hi);
        } else if (y.hi <= 0.0) {
            z.lo = RMath.mul_lo(x.hi, y.lo);
            z.hi = RMath.mul_hi(x.lo, y.lo);
        } else {
            z.lo = Math.min(RMath.mul_lo(x.hi, y.lo), RMath.mul_lo(x.lo, y.hi));
            z.hi = Math.max(RMath.mul_hi(x.lo, y.lo), RMath.mul_hi(x.hi, y.hi));
        }
        return z;
    }

    public static RealInterval div(RealInterval x, RealInterval y) {
        if (y.lo == 0.0 && y.hi == 0.0) {
            throw new IAException("div(X,Y): Division by Zero");
        }
        return IAMath.odiv(x, y);
    }

    public static RealInterval odiv(RealInterval x, RealInterval y) {
        RealInterval z = new RealInterval();
        if (x.lo <= 0.0 && 0.0 <= x.hi && y.lo <= 0.0 && 0.0 <= y.hi) {
            z.lo = Double.NEGATIVE_INFINITY;
            z.hi = Double.POSITIVE_INFINITY;
        } else {
            if (y.lo == 0.0) {
                y.lo = 0.0;
            }
            if (y.hi == 0.0) {
                y.hi = RMath.NegZero;
            }
            if (x.lo >= 0.0) {
                if (y.lo >= 0.0) {
                    z.lo = Math.max(0.0, RMath.div_lo(x.lo, y.hi));
                    z.hi = RMath.div_hi(x.hi, y.lo);
                } else if (y.hi <= 0.0) {
                    z.lo = RMath.div_lo(x.hi, y.hi);
                    z.hi = Math.min(0.0, RMath.div_hi(x.lo, y.lo));
                } else {
                    z.lo = Double.NEGATIVE_INFINITY;
                    z.hi = Double.POSITIVE_INFINITY;
                }
            } else if (x.hi <= 0.0) {
                if (y.lo >= 0.0) {
                    z.lo = RMath.div_lo(x.lo, y.lo);
                    z.hi = Math.min(0.0, RMath.div_hi(x.hi, y.hi));
                } else if (y.hi <= 0.0) {
                    z.lo = Math.max(0.0, RMath.div_lo(x.hi, y.lo));
                    z.hi = RMath.div_hi(x.lo, y.hi);
                } else {
                    z.lo = Double.NEGATIVE_INFINITY;
                    z.hi = Double.POSITIVE_INFINITY;
                }
            } else if (y.lo >= 0.0) {
                z.lo = RMath.div_lo(x.lo, y.lo);
                z.hi = RMath.div_hi(x.hi, y.lo);
            } else if (y.hi <= 0.0) {
                z.lo = RMath.div_lo(x.hi, y.hi);
                z.hi = RMath.div_hi(x.lo, y.hi);
            } else {
                z.lo = Double.NEGATIVE_INFINITY;
                z.hi = Double.POSITIVE_INFINITY;
            }
        }
        return z;
    }

    public static boolean intersect_odiv(RealInterval y, RealInterval z, RealInterval x) throws IAException {
        if (x.lo >= 0.0 || x.hi <= 0.0) {
            y.intersect(IAMath.odiv(z, x));
            return true;
        }
        if (z.lo > 0.0) {
            double tmp_neg = RMath.div_hi(z.lo, x.lo);
            double tmp_pos = RMath.div_lo(z.lo, x.hi);
            if ((y.lo > tmp_neg || y.lo == 0.0) && y.lo < tmp_pos) {
                y.lo = tmp_pos;
            }
            if ((y.hi < tmp_pos || y.hi == 0.0) && y.hi > tmp_neg) {
                y.hi = tmp_neg;
            }
            if (y.lo <= y.hi) {
                return true;
            }
            throw new IAException("intersect_odiv(Y,Z,X): intersection is an Empty Interval");
        }
        if (z.hi < 0.0) {
            double tmp_neg = RMath.div_hi(z.hi, x.hi);
            double tmp_pos = RMath.div_lo(z.hi, x.lo);
            if ((y.lo > tmp_neg || y.lo == 0.0) && y.lo < tmp_pos) {
                y.lo = tmp_pos;
            }
            if ((y.hi < tmp_pos || y.hi == 0.0) && y.hi > tmp_neg) {
                y.hi = tmp_neg;
            }
            if (y.lo <= y.hi) {
                return true;
            }
            throw new IAException("intersect_odiv(Y,Z,X): intersection is an Empty Interval");
        }
        return true;
    }

    public static RealInterval uminus(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = -x.hi;
        z.hi = -x.lo;
        return z;
    }

    public static RealInterval exp(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = RMath.exp_lo(x.lo);
        z.hi = RMath.exp_hi(x.hi);
        return z;
    }

    public static RealInterval log(RealInterval x) throws IAException {
        RealInterval z = new RealInterval();
        if (x.hi <= 0.0) {
            throw new IAException("log(X): X<=0 not allowed");
        }
        if (x.lo < 0.0) {
            x.lo = 0.0;
        }
        z.lo = RMath.log_lo(x.lo);
        z.hi = RMath.log_hi(x.hi);
        return z;
    }

    public static RealInterval sin(RealInterval x) {
        RealInterval y = new RealInterval();
        RealInterval z = new RealInterval();
        y = IAMath.div(x, new RealInterval(RMath.prevfp(Math.PI * 2), RMath.nextfp(Math.PI * 2)));
        z = IAMath.sin2pi(y);
        return z;
    }

    public static RealInterval cos(RealInterval x) {
        RealInterval y = new RealInterval();
        RealInterval z = new RealInterval();
        y = IAMath.div(x, new RealInterval(RMath.prevfp(Math.PI * 2), RMath.nextfp(Math.PI * 2)));
        z = IAMath.cos2pi(y);
        return z;
    }

    public static RealInterval tan(RealInterval x) {
        RealInterval y = new RealInterval();
        RealInterval z = new RealInterval();
        y = IAMath.div(x, new RealInterval(RMath.prevfp(Math.PI * 2), RMath.nextfp(Math.PI * 2)));
        z = IAMath.tan2pi(y);
        return z;
    }

    public static RealInterval asin(RealInterval x) throws IAException {
        RealInterval z = new RealInterval();
        x.intersect(new RealInterval(-1.0, 1.0));
        z.lo = RMath.asin_lo(x.lo);
        z.hi = RMath.asin_hi(x.hi);
        return z;
    }

    public static RealInterval acos(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = RMath.acos_lo(x.hi);
        z.hi = RMath.acos_hi(x.lo);
        return z;
    }

    public static RealInterval atan(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = RMath.atan_lo(x.lo);
        z.hi = RMath.atan_hi(x.hi);
        return z;
    }

    public static RealInterval sinRange(int a, int b) {
        switch (4 * a + b) {
            case 0: {
                return new RealInterval(-1.0, 1.0);
            }
            case 1: {
                return new RealInterval(1.0, 1.0);
            }
            case 2: {
                return new RealInterval(0.0, 1.0);
            }
            case 3: {
                return new RealInterval(-1.0, 1.0);
            }
            case 4: {
                return new RealInterval(-1.0, 0.0);
            }
            case 5: {
                return new RealInterval(-1.0, 1.0);
            }
            case 6: {
                return new RealInterval(0.0, 0.0);
            }
            case 7: {
                return new RealInterval(-1.0, 0.0);
            }
            case 8: {
                return new RealInterval(-1.0, 0.0);
            }
            case 9: {
                return new RealInterval(-1.0, 1.0);
            }
            case 10: {
                return new RealInterval(-1.0, 1.0);
            }
            case 11: {
                return new RealInterval(-1.0, -1.0);
            }
            case 12: {
                return new RealInterval(0.0, 0.0);
            }
            case 13: {
                return new RealInterval(0.0, 1.0);
            }
            case 14: {
                return new RealInterval(0.0, 1.0);
            }
            case 15: {
                return new RealInterval(-1.0, 1.0);
            }
        }
        System.out.println("ERROR in sinRange(" + a + "," + b + ")");
        return new RealInterval(-1.0, 1.0);
    }

    static RealInterval sin2pi0DI(double x) {
        return new RealInterval(RMath.sin2pi_lo(x), RMath.sin2pi_hi(x));
    }

    static RealInterval cos2pi0DI(double x) {
        return new RealInterval(RMath.cos2pi_lo(x), RMath.cos2pi_hi(x));
    }

    static RealInterval eval_sin2pi(double x, int a) {
        switch (a) {
            case 0: {
                return IAMath.sin2pi0DI(x);
            }
            case 1: {
                return IAMath.cos2pi0DI(x);
            }
            case 2: {
                return IAMath.uminus(IAMath.sin2pi0DI(x));
            }
            case 3: {
                return IAMath.uminus(IAMath.cos2pi0DI(x));
            }
        }
        System.out.println("ERROR in eval_sin2pi(" + x + "," + a + ")");
        return new RealInterval();
    }

    public static RealInterval sin2pi(RealInterval x) {
        long mlo;
        RealInterval r = new RealInterval();
        RealInterval z = null;
        RealInterval y1 = null;
        RealInterval y2 = null;
        int a = 0;
        int b = 0;
        double t1 = 0.0;
        double t2 = 0.0;
        if (Double.isInfinite(x.lo) || Double.isInfinite(x.hi)) {
            return new RealInterval(-1.0, 1.0);
        }
        double m1 = Math.rint(4.0 * x.lo);
        int j1 = (int)Math.round(m1 - 4.0 * Math.floor(m1 / 4.0));
        double z1 = RMath.sub_lo(x.lo, m1 / 4.0);
        double n1 = Math.floor(m1 / 4.0);
        double m2 = Math.rint(4.0 * x.hi);
        int j2 = (int)Math.round(m2 - 4.0 * Math.floor(m2 / 4.0));
        double z2 = RMath.sub_hi(x.hi, m2 / 4.0);
        double n2 = Math.floor(m2 / 4.0);
        if (z1 <= -0.25 || z1 >= 0.25 || z2 <= -0.25 || z2 >= 0.25) {
            return new RealInterval(-1.0, 1.0);
        }
        long mhi = z2 <= 0.0 ? (long)j2 : (long)(j2 + 1);
        double width = (double)(mhi - (mlo = z1 >= 0.0 ? (long)j1 : (long)(j1 - 1))) + 4.0 * (n2 - n1);
        if (width > 4.0) {
            return new RealInterval(-1.0, 1.0);
        }
        y1 = IAMath.eval_sin2pi(z1, j1);
        y2 = IAMath.eval_sin2pi(z2, j2);
        z = IAMath.union(y1, y2);
        a = (int)((mlo + 4L) % 4L);
        b = (int)((mhi + 3L) % 4L);
        if (width <= 1.0) {
            return z;
        }
        return IAMath.union(z, IAMath.sinRange(a, b));
    }

    public static RealInterval cos2pi(RealInterval x) {
        long mlo;
        RealInterval r = new RealInterval();
        RealInterval z = null;
        RealInterval y1 = null;
        RealInterval y2 = null;
        int a = 0;
        int b = 0;
        double t1 = 0.0;
        double t2 = 0.0;
        if (Double.isInfinite(x.lo) || Double.isInfinite(x.hi)) {
            return new RealInterval(-1.0, 1.0);
        }
        double m1 = Math.rint(4.0 * x.lo);
        int j1 = (int)Math.round(m1 - 4.0 * Math.floor(m1 / 4.0));
        double z1 = RMath.sub_lo(x.lo, m1 / 4.0);
        double n1 = Math.floor(m1 / 4.0);
        double m2 = Math.rint(4.0 * x.hi);
        int j2 = (int)Math.round(m2 - 4.0 * Math.floor(m2 / 4.0));
        double z2 = RMath.sub_hi(x.hi, m2 / 4.0);
        double n2 = Math.floor(m2 / 4.0);
        if (z1 <= -0.25 || z1 >= 0.25 || z2 <= -0.25 || z2 >= 0.25) {
            return new RealInterval(-1.0, 1.0);
        }
        long mhi = z2 <= 0.0 ? (long)j2 : (long)(j2 + 1);
        double width = (double)(mhi - (mlo = z1 >= 0.0 ? (long)j1 : (long)(j1 - 1))) + 4.0 * (n2 - n1);
        if (width > 4.0) {
            return new RealInterval(-1.0, 1.0);
        }
        y1 = IAMath.eval_sin2pi(z1, (j1 + 1) % 4);
        y2 = IAMath.eval_sin2pi(z2, (j2 + 1) % 4);
        z = IAMath.union(y1, y2);
        a = (int)((mlo + 4L + 1L) % 4L);
        b = (int)((mhi + 3L + 1L) % 4L);
        if (width <= 1.0) {
            return z;
        }
        return IAMath.union(z, IAMath.sinRange(a, b));
    }

    public static RealInterval tan2pi(RealInterval x) {
        return IAMath.div(IAMath.sin2pi(x), IAMath.cos2pi(x));
    }

    public static RealInterval asin2pi(RealInterval x) throws IAException {
        RealInterval z = new RealInterval();
        x.intersect(new RealInterval(-1.0, 1.0));
        z.lo = RMath.asin2pi_lo(x.lo);
        z.hi = RMath.asin2pi_hi(x.hi);
        return z;
    }

    public static RealInterval acos2pi(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = RMath.acos2pi_lo(x.hi);
        z.hi = RMath.acos2pi_hi(x.lo);
        return z;
    }

    public static RealInterval atan2pi(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = RMath.atan2pi_lo(x.lo);
        z.hi = RMath.atan2pi_hi(x.hi);
        return z;
    }

    public static RealInterval midpoint(RealInterval x) {
        RealInterval z = new RealInterval();
        z.hi = z.lo = (x.lo + x.hi) / 2.0;
        if (Double.NEGATIVE_INFINITY < z.lo && Double.POSITIVE_INFINITY > z.lo) {
            return z;
        }
        if (Double.NEGATIVE_INFINITY == x.lo) {
            if (x.hi > 0.0) {
                z.hi = z.lo = 0.0;
                return z;
            }
            if (x.hi == 0.0) {
                z.hi = z.lo = -1.0;
                return z;
            }
            z.hi = z.lo = x.hi * 2.0;
            return z;
        }
        if (Double.POSITIVE_INFINITY == x.hi) {
            if (x.lo < 0.0) {
                z.hi = z.lo = 0.0;
                return z;
            }
            if (x.lo == 0.0) {
                z.hi = z.lo = 1.0;
                return z;
            }
            z.hi = z.lo = x.lo * 2.0;
            return z;
        }
        z.lo = x.lo;
        z.hi = x.hi;
        System.out.println("Error in RealInterval.midpoint");
        return z;
    }

    public static RealInterval leftendpoint(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = x.lo;
        if (Double.NEGATIVE_INFINITY < z.lo && Double.POSITIVE_INFINITY > z.lo) {
            z.hi = z.lo;
            return z;
        }
        z.hi = z.lo = RMath.nextfp(x.lo);
        return z;
    }

    public static RealInterval rightendpoint(RealInterval x) {
        RealInterval z = new RealInterval();
        z.lo = x.hi;
        if (Double.NEGATIVE_INFINITY < z.lo && Double.POSITIVE_INFINITY > z.lo) {
            z.hi = z.lo;
            return z;
        }
        z.hi = z.lo = RMath.prevfp(x.hi);
        return z;
    }

    public static RealInterval power(RealInterval x, RealInterval y) throws IAException {
        if (x.hi <= 0.0) {
            throw new IAException("power(X,Y): X<=0 not allowed");
        }
        if (x.lo < 0.0) {
            x.lo = 0.0;
        }
        RealInterval z = IAMath.exp(IAMath.mul(y, IAMath.log(x)));
        return z;
    }

    public static RealInterval evenPower(RealInterval x, double y) throws IAException {
        double zhi;
        double zlo;
        if (y == 0.0) {
            return new RealInterval(1.0);
        }
        if (y > 0.0) {
            if (x.lo >= 0.0) {
                zlo = RMath.pow_lo(x.lo, y);
                zhi = RMath.pow_hi(x.hi, y);
            } else if (x.hi <= 0.0) {
                zlo = RMath.pow_lo(-x.hi, y);
                zhi = RMath.pow_hi(-x.lo, y);
            } else {
                zlo = 0.0;
                zhi = Math.max(RMath.pow_lo(-x.lo, y), RMath.pow_hi(x.hi, y));
            }
        } else {
            if (y < 0.0) {
                return IAMath.div(new RealInterval(1.0), IAMath.evenPower(x, -y));
            }
            throw new IAException("evenPower(X,y): y=Nan not allowed");
        }
        return new RealInterval(zlo, zhi);
    }

    public static RealInterval oddPower(RealInterval x, double y) throws IAException {
        double zhi;
        double zlo;
        if (y == 0.0) {
            if (x.lo > 0.0) {
                return new RealInterval(1.0);
            }
            if (x.hi < 0.0) {
                return new RealInterval(-1.0);
            }
            return new RealInterval(-1.0, 1.0);
        }
        if (y > 0.0) {
            if (x.lo >= 0.0) {
                zlo = RMath.pow_lo(x.lo, y);
                zhi = RMath.pow_hi(x.hi, y);
            } else if (x.hi <= 0.0) {
                zlo = -RMath.pow_hi(-x.lo, y);
                zhi = -RMath.pow_lo(-x.hi, y);
            } else {
                zlo = -RMath.pow_hi(-x.lo, y);
                zhi = RMath.pow_hi(x.hi, y);
            }
        } else {
            if (y < 0.0) {
                return IAMath.div(new RealInterval(1.0), IAMath.oddPower(x, -y));
            }
            throw new IAException("oddPower(X,y): X = NaN not allowed");
        }
        return new RealInterval(zlo, zhi);
    }

    public static RealInterval evenRoot(RealInterval x, double y) throws IAException {
        if (y == 0.0) {
            throw new IAException("evenRoot(X,y): y=0 not allowed");
        }
        if (y > 0.0) {
            double zhi;
            double ylo = RMath.div_lo(1.0, y);
            double yhi = RMath.div_hi(1.0, y);
            double zlo = x.lo >= 1.0 ? RMath.pow_lo(x.lo, ylo) : (x.lo >= 0.0 ? RMath.pow_lo(x.lo, yhi) : 0.0);
            if (x.hi >= 1.0) {
                zhi = RMath.pow_hi(x.hi, yhi);
            } else if (x.lo >= 0.0) {
                zhi = RMath.pow_hi(x.hi, ylo);
            } else {
                throw new IAException("evenRoot(X,y): X <=0 not allowed");
            }
            return new RealInterval(zlo, zhi);
        }
        if (y < 0.0) {
            return IAMath.div(new RealInterval(1.0), IAMath.evenRoot(x, -y));
        }
        throw new IAException("evenRoot(X,y): y=NaN not allowed");
    }

    public static RealInterval oddRoot(RealInterval x, double y) throws IAException {
        if (y == 0.0) {
            return RealInterval.fullInterval();
        }
        if (y > 0.0) {
            double ylo = RMath.div_lo(1.0, y);
            double yhi = RMath.div_hi(1.0, y);
            double zlo = x.lo >= 1.0 ? RMath.pow_lo(x.lo, ylo) : (x.lo >= 0.0 ? RMath.pow_lo(x.lo, yhi) : (x.lo >= -1.0 ? -RMath.pow_hi(-x.lo, ylo) : -RMath.pow_hi(-x.lo, yhi)));
            double zhi = x.hi >= 1.0 ? RMath.pow_hi(x.hi, yhi) : (x.hi >= 0.0 ? RMath.pow_hi(x.hi, ylo) : (x.hi >= -1.0 ? -RMath.pow_lo(-x.hi, yhi) : -RMath.pow_lo(-x.hi, ylo)));
            return new RealInterval(zlo, zhi);
        }
        if (y < 0.0) {
            return IAMath.div(new RealInterval(1.0), IAMath.oddRoot(x, -y));
        }
        throw new IAException("oddRoot(X,y): y=NaN not allowed");
    }

    public static RealInterval integerPower(RealInterval x, RealInterval y) throws IAException {
        if (y.lo != y.hi || Math.IEEEremainder(y.lo, 1.0) != 0.0) {
            return RealInterval.fullInterval();
        }
        double yy = y.lo;
        if (Math.IEEEremainder(yy, 2.0) == 0.0) {
            return IAMath.evenPower(x, yy);
        }
        return IAMath.oddPower(x, yy);
    }

    public static RealInterval integerRoot(RealInterval x, RealInterval y) throws IAException {
        if (y.lo != y.hi || Math.IEEEremainder(y.lo, 1.0) != 0.0) {
            return RealInterval.fullInterval();
        }
        double yy = y.lo;
        if (Math.IEEEremainder(yy, 2.0) == 0.0) {
            return IAMath.evenRoot(x, yy);
        }
        return IAMath.oddRoot(x, yy);
    }

    public static boolean intersectIntegerRoot(RealInterval x, RealInterval y, RealInterval u) throws IAException {
        if (y.lo != y.hi || Math.IEEEremainder(y.lo, 1.0) != 0.0) {
            return true;
        }
        double yy = y.lo;
        if (Math.IEEEremainder(yy, 2.0) != 0.0) {
            u.intersect(IAMath.oddRoot(x, yy));
        } else {
            RealInterval tmp = IAMath.evenRoot(x, yy);
            if (u.hi < tmp.lo) {
                u.intersect(IAMath.uminus(tmp));
            } else if (-tmp.lo < u.lo) {
                u.intersect(tmp);
            } else {
                u.intersect(new RealInterval(-tmp.hi, tmp.hi));
            }
        }
        return true;
    }

    public static void main(String[] argv) {
        RealInterval a = new RealInterval(5.0);
        RealInterval b = IAMath.log(a);
        RealInterval c = IAMath.exp(b);
        System.out.println("a= " + a);
        System.out.println("log(a)= " + b);
        System.out.println("exp(log(a))= " + c);
        try {
            a = new RealInterval(-5.0, 0.0);
            c = IAMath.exp(IAMath.log(a));
            System.out.println("a= " + a);
            System.out.println("exp(log(a))= " + c);
        }
        catch (Exception e) {
            System.out.println("Caught exception " + e);
        }
    }
}

