/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.ia_math;

public class RMath {
    static double Zero = 0.0;
    static double NegZero = -0.0;

    public static double nextfp(double x) {
        if (x == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (x < Double.POSITIVE_INFINITY) {
            long xx = Double.doubleToLongBits(x);
            double y = x > 0.0 ? Double.longBitsToDouble(xx + 1L) : (x == 0.0 ? Double.longBitsToDouble(1L) : Double.longBitsToDouble(xx - 1L));
            return y;
        }
        return x;
    }

    public static double prevfp(double x) {
        if (x == 0.0) {
            return -RMath.nextfp(0.0);
        }
        return -RMath.nextfp(-x);
    }

    public static double add_lo(double x, double y) {
        return RMath.prevfp(x + y);
    }

    public static double add_hi(double x, double y) {
        return RMath.nextfp(x + y);
    }

    public static double sub_lo(double x, double y) {
        return RMath.prevfp(x - y);
    }

    public static double sub_hi(double x, double y) {
        return RMath.nextfp(x - y);
    }

    public static double mul_lo(double x, double y) {
        if (x == 0.0 || y == 0.0) {
            return 0.0;
        }
        return RMath.prevfp(x * y);
    }

    public static double mul_hi(double x, double y) {
        if (x == 0.0 || y == 0.0) {
            return 0.0;
        }
        return RMath.nextfp(x * y);
    }

    public static double div_lo(double x, double y) {
        if (x == 0.0) {
            return 0.0;
        }
        return RMath.prevfp(x / y);
    }

    public static double div_hi(double x, double y) {
        if (x == 0.0) {
            return 0.0;
        }
        return RMath.nextfp(x / y);
    }

    public static double exp_lo(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x < Double.POSITIVE_INFINITY) {
            return Math.max(0.0, RMath.prevfp(Math.exp(x)));
        }
        return x;
    }

    public static double exp_hi(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x < Double.POSITIVE_INFINITY) {
            return RMath.nextfp(Math.exp(x));
        }
        return x;
    }

    public static double log_lo(double x) {
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x < Double.POSITIVE_INFINITY) {
            return RMath.prevfp(Math.log(x));
        }
        return x;
    }

    public static double log_hi(double x) {
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x < Double.POSITIVE_INFINITY) {
            return RMath.nextfp(Math.log(x));
        }
        return x;
    }

    public static double sin_lo(double x) {
        return RMath.prevfp(Math.sin(x));
    }

    public static double sin_hi(double x) {
        return RMath.nextfp(Math.sin(x));
    }

    public static double cos_lo(double x) {
        return RMath.prevfp(Math.cos(x));
    }

    public static double cos_hi(double x) {
        return RMath.nextfp(Math.cos(x));
    }

    public static double tan_lo(double x) {
        return RMath.prevfp(Math.tan(x));
    }

    public static double tan_hi(double x) {
        return RMath.nextfp(Math.tan(x));
    }

    public static double asin_lo(double x) {
        return RMath.prevfp(Math.asin(x));
    }

    public static double asin_hi(double x) {
        return RMath.nextfp(Math.asin(x));
    }

    public static double acos_lo(double x) {
        return RMath.prevfp(Math.acos(x));
    }

    public static double acos_hi(double x) {
        return RMath.nextfp(Math.acos(x));
    }

    public static double atan_lo(double x) {
        return RMath.prevfp(Math.atan(x));
    }

    public static double atan_hi(double x) {
        return RMath.nextfp(Math.atan(x));
    }

    static double sin2pi_lo(double x) {
        return RMath.prevfp(Math.sin(RMath.prevfp(Math.PI * 2 * x)));
    }

    static double sin2pi_hi(double x) {
        return RMath.nextfp(Math.sin(RMath.nextfp(Math.PI * 2 * x)));
    }

    static double cos2pi_lo(double x) {
        if (x > 0.0) {
            return RMath.prevfp(Math.cos(RMath.nextfp(Math.PI * 2 * x)));
        }
        return RMath.prevfp(Math.cos(RMath.prevfp(Math.PI * 2 * x)));
    }

    static double cos2pi_hi(double x) {
        if (x > 0.0) {
            return RMath.nextfp(Math.cos(RMath.prevfp(Math.PI * 2 * x)));
        }
        return RMath.nextfp(Math.cos(RMath.nextfp(Math.PI * 2 * x)));
    }

    static double tan2pi_lo(double x) {
        return RMath.prevfp(Math.tan(RMath.prevfp(Math.PI * 2 * x)));
    }

    static double tan2pi_hi(double x) {
        return RMath.nextfp(Math.tan(RMath.nextfp(Math.PI * 2 * x)));
    }

    static double asin2pi_lo(double x) {
        return RMath.prevfp(Math.asin(x) / RMath.nextfp(Math.PI * 2));
    }

    static double asin2pi_hi(double x) {
        return RMath.nextfp(Math.asin(x) / RMath.prevfp(Math.PI * 2));
    }

    static double acos2pi_lo(double x) {
        return RMath.prevfp(Math.acos(x) / RMath.nextfp(Math.PI * 2));
    }

    static double acos2pi_hi(double x) {
        return RMath.nextfp(Math.acos(x) / RMath.prevfp(Math.PI * 2));
    }

    static double atan2pi_lo(double x) {
        return RMath.prevfp(Math.atan(x) / RMath.nextfp(Math.PI * 2));
    }

    static double atan2pi_hi(double x) {
        return RMath.nextfp(Math.atan(x) / RMath.prevfp(Math.PI * 2));
    }

    public static double pow_lo(double x, double y) {
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (y > 0.0) {
            if (x >= 1.0) {
                return RMath.exp_lo(RMath.mul_lo(y, RMath.log_lo(x)));
            }
            if (x == 1.0) {
                return 1.0;
            }
            return RMath.exp_lo(RMath.mul_lo(y, RMath.log_hi(x)));
        }
        if (y == 0.0) {
            return 1.0;
        }
        if (x >= 1.0) {
            return RMath.exp_lo(RMath.mul_lo(y, RMath.log_hi(x)));
        }
        if (x == 1.0) {
            return 1.0;
        }
        return RMath.exp_lo(RMath.mul_lo(y, RMath.log_lo(x)));
    }

    public static double pow_hi(double x, double y) {
        if (x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (y > 0.0) {
            if (x >= 1.0) {
                return RMath.exp_hi(RMath.mul_hi(y, RMath.log_hi(x)));
            }
            if (x == 1.0) {
                return 1.0;
            }
            return RMath.exp_hi(RMath.mul_hi(y, RMath.log_lo(x)));
        }
        if (y == 0.0) {
            return 1.0;
        }
        if (x >= 1.0) {
            return RMath.exp_lo(RMath.mul_hi(y, RMath.log_lo(x)));
        }
        if (x == 1.0) {
            return 1.0;
        }
        return RMath.exp_lo(RMath.mul_hi(y, RMath.log_hi(x)));
    }

    public static void main(String[] argv) {
        double a = 1.0E-300;
        System.out.println("   Zero = " + Zero);
        System.out.println("NegZero = " + NegZero);
        System.out.println("prevfp(Zero) = " + RMath.prevfp(Zero));
        System.out.println("nextfp(Zero) = " + RMath.nextfp(Zero));
        System.out.println("a = " + a);
        System.out.println("mul_lo(a,a) = " + RMath.mul_lo(a, a));
        System.out.println("mul_hi(a,a) = " + RMath.mul_hi(a, a));
    }
}

