/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.ia_math;

import de.gaalop.visualizer.ia_math.IAException;
import de.gaalop.visualizer.ia_math.IAMath;

public class RealInterval
implements Cloneable {
    double lo;
    double hi;

    public RealInterval(double lo, double hi) throws IAException {
        if (!(lo <= hi)) {
            throw new IAException("RealInterval(x=" + lo + ",y=" + hi + "): must have x<=y");
        }
        this.lo = lo;
        this.hi = hi;
    }

    public RealInterval(double x) throws IAException {
        if (!(Double.NEGATIVE_INFINITY < x) || !(x < Double.POSITIVE_INFINITY)) {
            throw new IAException("RealInterval(x): must have -inf<x<inf");
        }
        this.lo = x;
        this.hi = x;
    }

    public RealInterval() {
        this.lo = Double.NEGATIVE_INFINITY;
        this.hi = Double.POSITIVE_INFINITY;
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean equals(RealInterval x) {
        return this.lo == x.lo && this.hi == x.hi;
    }

    public void intersect(RealInterval x) throws IAException {
        this.lo = Math.max(this.lo, x.lo);
        this.hi = Math.min(this.hi, x.hi);
        if (this.lo <= this.hi) {
            return;
        }
        throw new IAException("this.intersect(X): intersection is empty");
    }

    public void union(RealInterval x) throws IAException {
        this.lo = Math.min(this.lo, x.lo);
        this.hi = Math.max(this.hi, x.hi);
    }

    public boolean nonEmpty() {
        return this.lo <= this.hi;
    }

    public String toString() {
        return this.toString2();
    }

    private String toString1() {
        return new String("[" + this.doubleToString(this.lo) + " , " + this.doubleToString(this.hi) + "]");
    }

    private String toString1a() {
        return new String("[" + new Double(this.lo).toString() + " , " + new Double(this.hi).toString() + "]");
    }

    private String toString2() {
        Double midpoint = new Double((this.lo + this.hi) / 2.0);
        String midpointString = this.doubleToString((this.lo + this.hi) / 2.0);
        String hi1String = this.doubleToString(this.hi - midpoint);
        if (Math.abs(midpoint) > (this.hi - this.lo) / 2.0) {
            return new String("(" + midpointString + " +/- " + hi1String + ") ");
        }
        return this.toString1();
    }

    private String doubleToString(double x) {
        StringBuffer s = new StringBuffer(new Double(x).toString());
        int i = s.length();
        int j = 1;
        while (j < 20 - i) {
            s.append(' ');
            ++i;
        }
        return s.toString();
    }

    public Object clone() {
        return new RealInterval(this.lo, this.hi);
    }

    public static RealInterval emptyInterval() {
        RealInterval z = new RealInterval(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return z;
    }

    public static RealInterval fullInterval() {
        RealInterval z = new RealInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        return z;
    }

    public static void main(String[] args) {
        RealInterval x = new RealInterval(-3.0, -2.0);
        RealInterval y = new RealInterval(-6.0, 7.0);
        RealInterval z = new RealInterval();
        RealInterval w = new RealInterval();
        z = IAMath.add(x, y);
        System.out.println("x = [" + x.lo + " , " + x.hi + "]");
        System.out.println("y = [" + y.lo + " , " + y.hi + "]");
        System.out.println("x+y = [" + z.lo + " , " + z.hi + "]");
        w = IAMath.mul(x, y);
        System.out.println("x*y = [" + w.lo + " , " + w.hi + "]");
    }
}

