/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.zerofinding;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.visualizer.ia_math.IAMath;
import de.gaalop.visualizer.ia_math.RealInterval;
import de.gaalop.visualizer.zerofinding.CodePiece;
import java.util.HashMap;

public class IntervalEvaluater
implements ExpressionVisitor {
    private HashMap<MultivectorComponent, RealInterval> values;
    private RealInterval result;

    public IntervalEvaluater(HashMap<MultivectorComponent, RealInterval> values) {
        this.values = values;
    }

    public HashMap<MultivectorComponent, RealInterval> getValues() {
        return this.values;
    }

    public void evaluate(CodePiece codePiece) {
        for (AssignmentNode node : codePiece) {
            this.visit(node);
        }
    }

    public void visit(Subtraction node) {
        node.getLeft().accept((ExpressionVisitor)this);
        RealInterval left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        this.result = IAMath.sub(left, this.result);
    }

    public void visit(Addition node) {
        node.getLeft().accept((ExpressionVisitor)this);
        RealInterval left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        this.result = IAMath.add(left, this.result);
    }

    public void visit(Division node) {
        node.getLeft().accept((ExpressionVisitor)this);
        RealInterval left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        this.result = IAMath.div(left, this.result);
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        RealInterval left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        this.result = IAMath.mul(left, this.result);
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        this.result = IAMath.uminus(this.result);
    }

    public void visit(MathFunctionCall node) {
        node.getOperand().accept((ExpressionVisitor)this);
        switch (node.getFunction()) {
            case ABS: {
                this.result = new RealInterval(Math.min(this.result.lo(), this.result.hi()), Math.max(this.result.lo(), this.result.hi()));
                break;
            }
            case ACOS: {
                this.result = IAMath.acos(this.result);
                break;
            }
            case ASIN: {
                this.result = IAMath.asin(this.result);
                break;
            }
            case ATAN: {
                this.result = IAMath.atan(this.result);
                break;
            }
            case CEIL: {
                this.result = new RealInterval(Math.ceil(this.result.lo()), Math.ceil(this.result.hi()));
                break;
            }
            case COS: {
                this.result = IAMath.cos(this.result);
                break;
            }
            case EXP: {
                this.result = IAMath.exp(this.result);
                break;
            }
            case FACT: {
                int n = (int)this.result.lo();
                double r = 1.0;
                for (int i = 2; i <= n; ++i) {
                    r *= (double)i;
                }
                this.result = new RealInterval(r);
                break;
            }
            case FLOOR: {
                this.result = new RealInterval(Math.floor(this.result.lo()), Math.floor(this.result.hi()));
                break;
            }
            case LOG: {
                this.result = IAMath.log(this.result);
                break;
            }
            case SIN: {
                this.result = IAMath.sin(this.result);
                break;
            }
            case SQRT: {
                this.result = new RealInterval(Math.sqrt(this.result.lo()), Math.sqrt(this.result.hi()));
                break;
            }
            case TAN: {
                this.result = IAMath.tan(this.result);
            }
        }
    }

    public void visit(MultivectorComponent node) {
        RealInterval r = this.values.get(node);
        this.result = new RealInterval(r.lo(), r.hi());
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        RealInterval left = this.result;
        node.getRight().accept((ExpressionVisitor)this);
        double hi = this.result.hi();
        if (Math.abs(hi - this.result.lo()) < 0.001 && Math.abs(hi - (double)((int)hi)) < 0.001 && hi >= 0.0) {
            this.result = new RealInterval(1.0);
            for (int i = 0; i < (int)hi; ++i) {
                this.result = IAMath.mul(this.result, left);
            }
        } else {
            this.result = IAMath.power(left, this.result);
        }
    }

    public void visit(FloatConstant node) {
        this.result = new RealInterval(node.getValue());
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept((ExpressionVisitor)this);
        this.values.put((MultivectorComponent)node.getVariable(), this.result);
    }

    public void visit(Variable node) {
        MultivectorComponent m = new MultivectorComponent(node.getName(), 0);
        if (!this.values.containsKey(m)) {
            System.err.println("Interval Evaluater: Kein Wert gefunden! " + m.toString());
            return;
        }
        RealInterval r = this.values.get(m);
        if (r != null) {
            this.result = new RealInterval(r.lo(), r.hi());
        } else {
            this.result = null;
            System.err.println("Interval Evaluater: Kein Wert 2 gefunden! " + m.toString());
        }
    }

    public void visit(OuterProduct node) {
        throw new UnsupportedOperationException("OuterProducts should have been removed by TBA.");
    }

    public void visit(BaseVector node) {
        throw new UnsupportedOperationException("BaseVectors should have been removed by TBA.");
    }

    public void visit(Reverse node) {
        throw new UnsupportedOperationException("Reverses should have been removed by TBA.");
    }

    public void visit(LogicalOr node) {
        throw new UnsupportedOperationException("LogicalOrs should have been removed by TBA.");
    }

    public void visit(LogicalAnd node) {
        throw new UnsupportedOperationException("LogicalAnds should have been removed by TBA.");
    }

    public void visit(LogicalNegation node) {
        throw new UnsupportedOperationException("LogicalNegations should have been removed by TBA.");
    }

    public void visit(Equality node) {
        throw new UnsupportedOperationException("Equalities should have been removed by TBA.");
    }

    public void visit(Inequality node) {
        throw new UnsupportedOperationException("Inequalities should have been removed by TBA.");
    }

    public void visit(Relation relation) {
        throw new UnsupportedOperationException("Relations should have been removed by TBA.");
    }

    public void visit(FunctionArgument node) {
        throw new UnsupportedOperationException("FunctionArguments should have been removed by TBA.");
    }

    public void visit(MacroCall node) {
        throw new UnsupportedOperationException("MacroCalls should have been removed by TBA.");
    }

    public void visit(InnerProduct node) {
        throw new UnsupportedOperationException("Inner products should have been removed by TBA.");
    }
}

