/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualizer.zerofinding;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Variable;
import de.gaalop.visualizer.zerofinding.CodePiece;
import de.gaalop.visualizer.zerofinding.ZeroFinder;
import java.util.HashMap;
import java.util.LinkedList;

public abstract class PrepareZerofinder
extends ZeroFinder {
    public static LinkedList<AssignmentNode> createSumOfSquares(LinkedList<AssignmentNode> nodes) {
        HashMap collect = new HashMap();
        for (AssignmentNode node : nodes) {
            MultivectorComponent m = (MultivectorComponent)node.getVariable();
            String name = m.getName();
            if (!collect.containsKey(name)) {
                collect.put(name, new LinkedList());
            }
            ((LinkedList)collect.get(name)).add(node);
        }
        LinkedList<AssignmentNode> myNodes = new LinkedList<AssignmentNode>();
        for (String s : collect.keySet()) {
            if (!s.startsWith("_V_PRODUCT")) continue;
            Exponentiation sumOfSquares = null;
            for (AssignmentNode node : (LinkedList)collect.get(s)) {
                Exponentiation square = new Exponentiation(node.getValue(), (Expression)new FloatConstant(2.0));
                if (sumOfSquares == null) {
                    sumOfSquares = square;
                    continue;
                }
                sumOfSquares = new Addition((Expression)sumOfSquares, (Expression)square);
            }
            if (sumOfSquares == null) continue;
            AssignmentNode newNode = new AssignmentNode(null, (Variable)new MultivectorComponent(s + "_S", 0), (Expression)sumOfSquares);
            myNodes.add(newNode);
            PrepareZerofinder.listInsertBefore(myNodes, newNode, (AssignmentNode)((LinkedList)collect.get(s)).getFirst());
            for (AssignmentNode node : (LinkedList)collect.get(s)) {
                myNodes.remove(node);
            }
        }
        return myNodes;
    }

    protected static LinkedList<CodePiece> optimizeCodePieces(LinkedList<AssignmentNode> nodes) {
        LinkedList<CodePiece> codePieces = new LinkedList<CodePiece>();
        HashMap<String, CodePiece> mapCodePieces = new HashMap<String, CodePiece>();
        for (AssignmentNode node : nodes) {
            String name = node.getVariable().getName();
            if (!mapCodePieces.containsKey(name)) {
                CodePiece cp = new CodePiece();
                cp.nameOfMultivector = name;
                mapCodePieces.put(name, cp);
                codePieces.add(cp);
            }
            ((CodePiece)mapCodePieces.get(name)).add(node);
        }
        return codePieces;
    }

    protected static void listInsertBefore(LinkedList<AssignmentNode> list, AssignmentNode toInsert, AssignmentNode before) {
        LinkedList<AssignmentNode> listCopy = new LinkedList<AssignmentNode>(list);
        list.clear();
        for (AssignmentNode node : listCopy) {
            if (node == before) {
                list.add(toInsert);
            }
            list.add(node);
        }
    }
}

