/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.vis2d;

import de.gaalop.vis2d.Vis2dCodeGen;
import de.gaalop.vis2d.drawing.DrawVisitorBufferedImage;
import de.gaalop.vis2d.drawing.DrawVisitorPrintable;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Interaction
implements KeyListener,
MouseMotionListener,
MouseListener,
MouseWheelListener {
    public Vis2dCodeGen vis2dCodeGen;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private Point from;

    public Interaction(Vis2dCodeGen vis2dCodeGen) {
        this.vis2dCodeGen = vis2dCodeGen;
    }

    public void initialize() {
        this.vis2dCodeGen.vis2dUI.addKeyListener(this);
        this.vis2dCodeGen.panel.addMouseMotionListener(this);
        this.vis2dCodeGen.panel.addMouseListener(this);
        this.vis2dCodeGen.panel.addMouseWheelListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Rectangle2D.Double world = this.vis2dCodeGen.world;
        switch (e.getKeyCode()) {
            case 37: {
                world.x -= world.getWidth() / 10.0;
                break;
            }
            case 39: {
                world.x += world.getWidth() / 10.0;
                break;
            }
            case 38: {
                world.y += world.getHeight() / 10.0;
                break;
            }
            case 40: {
                world.y -= world.getHeight() / 10.0;
                break;
            }
            case 45: {
                world.x -= world.width / 2.0;
                world.y -= world.height / 2.0;
                world.width *= 2.0;
                world.height *= 2.0;
                break;
            }
            case 521: {
                world.width /= 2.0;
                world.height /= 2.0;
                world.x += world.width / 2.0;
                world.y += world.height / 2.0;
                break;
            }
            case 80: {
                PrinterJob job = PrinterJob.getPrinterJob();
                if (!job.printDialog()) {
                    return;
                }
                job.setPrintable(new DrawVisitorPrintable(this.vis2dCodeGen.drawing, world));
                try {
                    job.print();
                }
                catch (PrinterException ex) {
                    Logger.getLogger(Vis2dCodeGen.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case 83: {
                JFileChooser jFC = new JFileChooser();
                jFC.setFileFilter(new FileNameExtensionFilter("PNG-Dateien", "png"));
                if (jFC.showSaveDialog(null) != 0) break;
                File f = jFC.getSelectedFile();
                DrawVisitorBufferedImage imageVisitor = new DrawVisitorBufferedImage(world, 500, 500);
                this.vis2dCodeGen.drawing.draw(imageVisitor);
                try {
                    ImageIO.write((RenderedImage)imageVisitor.getImage(), "png", f);
                    break;
                }
                catch (IOException ex) {
                    Logger.getLogger(Vis2dCodeGen.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.vis2dCodeGen.repaintDrawing();
        this.updateLabelPosition();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point2D.Double pFrom = this.vis2dCodeGen.visitor.transformPointBack(this.from.x, this.from.y);
        Point to = e.getPoint();
        Point2D.Double pTo = this.vis2dCodeGen.visitor.transformPointBack(to.x, to.y);
        this.vis2dCodeGen.world.x -= pTo.x - pFrom.x;
        this.vis2dCodeGen.world.y -= pTo.y - pFrom.y;
        this.from = to;
        this.vis2dCodeGen.repaintDrawing();
        this.updateLabelPosition();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMouseX = e.getX();
        this.lastMouseY = e.getY();
        this.updateLabelPosition();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.from = new Point(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Rectangle2D.Double world = this.vis2dCodeGen.world;
        int wheelRotation = e.getWheelRotation();
        if (wheelRotation >= 0) {
            for (int i = 0; i < wheelRotation; ++i) {
                world.x -= world.width / 2.0;
                world.y -= world.height / 2.0;
                world.width *= 2.0;
                world.height *= 2.0;
            }
        } else {
            for (int i = -wheelRotation; i > 0; --i) {
                world.width /= 2.0;
                world.height /= 2.0;
                world.x += world.width / 2.0;
                world.y += world.height / 2.0;
            }
        }
        this.vis2dCodeGen.repaintDrawing();
    }

    private void updateLabelPosition() {
        Point2D.Double p = this.vis2dCodeGen.visitor.transformPointBack(this.lastMouseX, this.lastMouseY);
        this.vis2dCodeGen.vis2dUI.laPosition.setText(this.round(p.x) + " | " + this.round(p.y));
    }

    public double round(double val) {
        double f = (double)this.vis2dCodeGen.panel.getWidth() / this.vis2dCodeGen.world.width;
        int v = (int)Math.round(val * f);
        return (double)v / f;
    }
}

