/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.vis2d;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.Arrays;
import java.util.HashMap;

public class ValueEvaluater
extends EmptyControlFlowVisitor
implements ExpressionVisitor {
    private HashMap<String, double[]> values = new HashMap();
    private double resultValue;

    private ValueEvaluater() {
    }

    public static HashMap<String, double[]> evaluateValues(ControlFlowGraph graph) {
        ValueEvaluater valueEvaluater = new ValueEvaluater();
        graph.accept((ControlFlowVisitor)valueEvaluater);
        return valueEvaluater.values;
    }

    public void visit(AssignmentNode node) {
        double[] arrValues;
        node.getValue().accept((ExpressionVisitor)this);
        MultivectorComponent mvC = (MultivectorComponent)node.getVariable();
        if (this.values.containsKey(mvC.getName())) {
            arrValues = this.values.get(mvC.getName());
        } else {
            arrValues = new double[16];
            Arrays.fill(arrValues, 0.0);
            this.values.put(mvC.getName(), arrValues);
        }
        arrValues[mvC.getBladeIndex()] = this.resultValue;
        super.visit(node);
    }

    public void visit(Subtraction node) {
        node.getLeft().accept((ExpressionVisitor)this);
        double leftValue = this.resultValue;
        node.getRight().accept((ExpressionVisitor)this);
        this.resultValue = leftValue - this.resultValue;
    }

    public void visit(Addition node) {
        node.getLeft().accept((ExpressionVisitor)this);
        double leftValue = this.resultValue;
        node.getRight().accept((ExpressionVisitor)this);
        this.resultValue = leftValue + this.resultValue;
    }

    public void visit(Division node) {
        node.getLeft().accept((ExpressionVisitor)this);
        double leftValue = this.resultValue;
        node.getRight().accept((ExpressionVisitor)this);
        this.resultValue = leftValue / this.resultValue;
    }

    public void visit(InnerProduct node) {
        throw new IllegalStateException("InnerProducts should have been removed by TBA");
    }

    public void visit(Multiplication node) {
        node.getLeft().accept((ExpressionVisitor)this);
        double leftValue = this.resultValue;
        node.getRight().accept((ExpressionVisitor)this);
        this.resultValue = leftValue * this.resultValue;
    }

    public void visit(MathFunctionCall node) {
        node.accept((ExpressionVisitor)this);
        double operandValue = this.resultValue;
        switch (node.getFunction()) {
            case ABS: {
                this.resultValue = Math.abs(operandValue);
                break;
            }
            case ACOS: {
                this.resultValue = Math.acos(operandValue);
                break;
            }
            case ASIN: {
                this.resultValue = Math.asin(operandValue);
                break;
            }
            case ATAN: {
                this.resultValue = Math.atan(operandValue);
                break;
            }
            case CEIL: {
                this.resultValue = Math.ceil(operandValue);
                break;
            }
            case COS: {
                this.resultValue = Math.cos(operandValue);
                break;
            }
            case EXP: {
                this.resultValue = Math.exp(operandValue);
                break;
            }
            case FACT: {
                this.resultValue = 1.0;
                for (int i = 2; i <= (int)operandValue; ++i) {
                    this.resultValue *= (double)i;
                }
                break;
            }
            case FLOOR: {
                this.resultValue = Math.floor(operandValue);
                break;
            }
            case LOG: {
                this.resultValue = Math.log(operandValue);
                break;
            }
            case SIN: {
                this.resultValue = Math.sin(operandValue);
                break;
            }
            case SQRT: {
                this.resultValue = Math.sqrt(operandValue);
                break;
            }
            case TAN: {
                this.resultValue = Math.tan(operandValue);
                break;
            }
            case INVERT: {
                System.err.println("Inversions are not yet implemented in Vis2dCodeGen");
            }
        }
    }

    public void visit(Variable node) {
        throw new IllegalStateException("Variables are not yet allowed in Vis2dCodeGen");
    }

    public void visit(MultivectorComponent node) {
        this.resultValue = this.values.get(node.getName())[node.getBladeIndex()];
    }

    public void visit(Exponentiation node) {
        node.getLeft().accept((ExpressionVisitor)this);
        double leftValue = this.resultValue;
        node.getRight().accept((ExpressionVisitor)this);
        this.resultValue = Math.pow(leftValue, this.resultValue);
    }

    public void visit(FloatConstant node) {
        this.resultValue = node.getValue();
    }

    public void visit(OuterProduct node) {
        throw new IllegalStateException("OuterProducts should have been removed by TBA");
    }

    public void visit(BaseVector node) {
        throw new IllegalStateException("BaseVector should have been removed by TBA");
    }

    public void visit(Negation node) {
        node.getOperand().accept((ExpressionVisitor)this);
        this.resultValue = -this.resultValue;
    }

    public void visit(Reverse node) {
        throw new IllegalStateException("Reverse should have been removed by TBA");
    }

    public void visit(LogicalOr node) {
        throw new IllegalStateException("LogicalOrs are not allowed in Vis2dCodeGen");
    }

    public void visit(LogicalAnd node) {
        throw new IllegalStateException("LogicalAnds are not allowed in Vis2dCodeGen");
    }

    public void visit(LogicalNegation node) {
        throw new IllegalStateException("LogicalNegations are not allowed in Vis2dCodeGen");
    }

    public void visit(Equality node) {
        throw new IllegalStateException("Equalities are not allowed in Vis2dCodeGen");
    }

    public void visit(Inequality node) {
        throw new IllegalStateException("Inequalities are not allowed in Vis2dCodeGen");
    }

    public void visit(Relation relation) {
        throw new IllegalStateException("Relations are not allowed in Vis2dCodeGen");
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("FunctionArguments are not allowed in Vis2dCodeGen");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("MacroCalls are not allowed in Vis2dCodeGen");
    }
}

