/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.vis2d.drawing;

import de.gaalop.vis2d.RecLineDouble;
import de.gaalop.vis2d.drawing.DrawObject;
import de.gaalop.vis2d.drawing.DrawVisitor;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;

public class Gerade2d
extends DrawObject {
    private static final double EPSILON = 0.001;
    public double originX;
    public double originY;
    public double directionX;
    public double directionY;

    public Gerade2d(double originX, double originY, double directionX, double directionY, Color color) {
        super(color);
        this.originX = originX;
        this.originY = originY;
        this.directionX = directionX;
        this.directionY = directionY;
    }

    @Override
    public void accept(DrawVisitor visitor) {
        visitor.visitGerade2d(this);
    }

    public Line2D getLineOnRectangle(Rectangle2D rectangle) {
        if (this.floatEquals(this.directionX, 0.0)) {
            if (this.contains(this.originX, rectangle.getMinX(), rectangle.getMaxX())) {
                return new Line2D.Double(this.originX, rectangle.getMinY(), this.originX, rectangle.getMaxY());
            }
            return null;
        }
        if (this.floatEquals(this.directionY, 0.0)) {
            if (this.contains(this.originY, rectangle.getMinY(), rectangle.getMaxY())) {
                return new Line2D.Double(rectangle.getMinX(), this.originY, rectangle.getMaxX(), this.originY);
            }
            return null;
        }
        Line2D.Double thisLine = new Line2D.Double(this.originX, this.originY, this.originX + this.directionX, this.originY + this.directionY);
        Line2D.Double o = new Line2D.Double(rectangle.getMinX(), rectangle.getMaxY(), rectangle.getMaxX(), rectangle.getMaxY());
        Line2D.Double r = new Line2D.Double(rectangle.getMaxX(), rectangle.getMaxY(), rectangle.getMaxX(), rectangle.getMinY());
        Line2D.Double u = new Line2D.Double(rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMinX(), rectangle.getMinY());
        Line2D.Double l = new Line2D.Double(rectangle.getMinX(), rectangle.getMinY(), rectangle.getMinX(), rectangle.getMaxY());
        RecLineDouble[] arr = new RecLineDouble[]{new RecLineDouble(this.intersectTwoLines(o, thisLine), o), new RecLineDouble(this.intersectTwoLines(u, thisLine), u), new RecLineDouble(this.intersectTwoLines(l, thisLine), l), new RecLineDouble(this.intersectTwoLines(r, thisLine), r)};
        Arrays.sort(arr, new Comparator<RecLineDouble>(){

            @Override
            public int compare(RecLineDouble o1, RecLineDouble o2) {
                return Double.compare(o1.f, o2.f);
            }
        });
        return new Line2D.Double(this.getX(arr[0]), this.getY(arr[0]), this.getX(arr[1]), this.getY(arr[1]));
    }

    private double getX(RecLineDouble r) {
        return r.l.getX1() + r.f * (r.l.getX2() - r.l.getX1());
    }

    private double getY(RecLineDouble r) {
        return r.l.getY1() + r.f * (r.l.getY2() - r.l.getY1());
    }

    public double intersectTwoLines(Line2D s, Line2D l) {
        double det = this.getDx(l) * this.getDy(s) - this.getDx(s) * this.getDy(l);
        return (this.getDx(l) * (l.getY1() - s.getY1()) + this.getDy(l) * (s.getX1() - l.getX1())) / det;
    }

    private double getDx(Line2D l) {
        return l.getX2() - l.getX1();
    }

    private double getDy(Line2D l) {
        return l.getY2() - l.getY1();
    }

    private boolean contains(double test, double start, double end) {
        return start <= test && test <= end;
    }

    private boolean floatEquals(double f1, double f2) {
        return Math.abs(f1 - f2) <= 0.001;
    }

    public String toString() {
        return "Gerade2d ox=" + this.originX + ",oy=" + this.originY + ",dx=" + this.directionX + ",dy=" + this.directionY;
    }
}

