/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.input;

import de.gaalop.CodeParser;
import de.gaalop.CodeParserException;
import de.gaalop.InputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.clucalc.input.CluCalcLexer;
import de.gaalop.clucalc.input.CluCalcParser;
import de.gaalop.clucalc.input.CluVisitor;
import de.gaalop.clucalc.input.Plugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedList;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum CluCalcCodeParser implements CodeParser
{
    INSTANCE;

    private static final Log log;
    private Plugin plugin;

    public void setPluginReference(Plugin plugin) {
        if (this.plugin == null) {
            this.plugin = plugin;
        }
    }

    public ControlFlowGraph parseFile(InputFile input) throws CodeParserException {
        ControlFlowGraph graph;
        log.debug((Object)("Processing " + input.getName() + ", Content: \n" + input.getContent()));
        try {
            graph = this.parse(input);
        }
        catch (Throwable e) {
            throw new CodeParserException(input, e.getMessage(), e);
        }
        graph.setSource(input);
        return graph;
    }

    private ControlFlowGraph parse(InputFile input) throws CodeParserException, IOException {
        LinkedList<String> onlyEvaluates = new LinkedList<String>();
        LinkedList<String> outputs = new LinkedList<String>();
        String content = input.getContent();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = null;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.trim().startsWith("//#pragma")) {
                String[] parts;
                String line2 = line.replaceAll("\t", " ");
                while (line2.contains("  ")) {
                    line2 = line2.replaceAll("  ", " ");
                }
                String whichPragma = line2.substring(10, line2.indexOf(" ", 10));
                if (whichPragma.equals("range") || whichPragma.equals("unroll") || whichPragma.equals("count")) {
                    builder.append(line);
                    builder.append("\n");
                    continue;
                }
                String rest = line2.substring(line2.indexOf(" ", 10) + 1);
                if (whichPragma.equals("output")) {
                    parts = rest.split(" ");
                    for (int i = 1; i < parts.length; ++i) {
                        outputs.add(parts[0] + " " + parts[i]);
                    }
                    continue;
                }
                if (whichPragma.equals("onlyEvaluate")) {
                    parts = rest.split(" ");
                    onlyEvaluates.addAll(Arrays.asList(parts));
                    continue;
                }
                throw new CodeParserException(input, "pragma " + whichPragma + " is unknown.");
            }
            builder.append(line);
            builder.append("\n");
        }
        String program = builder.toString();
        ANTLRInputStream inputStream = new ANTLRInputStream((Reader)new StringReader(program));
        CluCalcLexer lexer = new CluCalcLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        CluCalcParser parser = new CluCalcParser((TokenStream)tokenStream);
        CluVisitor visitor = new CluVisitor();
        visitor.visit((ParseTree)parser.script());
        ControlFlowGraph graph = visitor.graph;
        for (String output : outputs) {
            graph.getPragmaOutputVariables().add(output);
        }
        for (String onlyEval : onlyEvaluates) {
            graph.getPragmaOnlyEvaluateVariables().add(onlyEval);
        }
        return graph;
    }

    static {
        log = LogFactory.getLog(CluCalcCodeParser.class);
    }
}

