/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.clucalc.output;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.HashMap;
import java.util.Map;

public class OperatorPriority {
    private static final Map<Class<? extends Expression>, Integer> OPERATOR_PRIORITY = new HashMap<Class<? extends Expression>, Integer>();

    public static boolean hasLowerPriority(Expression parent, Expression child) {
        Integer parentPriority = OPERATOR_PRIORITY.get(parent.getClass());
        Integer childPriority = OPERATOR_PRIORITY.get(child.getClass());
        if (parentPriority == null || childPriority == null) {
            return true;
        }
        return childPriority < parentPriority;
    }

    static {
        OPERATOR_PRIORITY.put(BaseVector.class, 1000);
        OPERATOR_PRIORITY.put(FloatConstant.class, 1000);
        OPERATOR_PRIORITY.put(Variable.class, 1000);
        OPERATOR_PRIORITY.put(MultivectorComponent.class, 1000);
        OPERATOR_PRIORITY.put(MathFunctionCall.class, 1000);
        OPERATOR_PRIORITY.put(Negation.class, 990);
        OPERATOR_PRIORITY.put(Exponentiation.class, 985);
        OPERATOR_PRIORITY.put(OuterProduct.class, 980);
        OPERATOR_PRIORITY.put(InnerProduct.class, 970);
        OPERATOR_PRIORITY.put(Multiplication.class, 960);
        OPERATOR_PRIORITY.put(Division.class, 960);
        OPERATOR_PRIORITY.put(Subtraction.class, 950);
        OPERATOR_PRIORITY.put(Addition.class, 940);
        OPERATOR_PRIORITY.put(Relation.class, 930);
        OPERATOR_PRIORITY.put(LogicalAnd.class, 930);
        OPERATOR_PRIORITY.put(LogicalOr.class, 930);
        OPERATOR_PRIORITY.put(Equality.class, 920);
        OPERATOR_PRIORITY.put(Inequality.class, 920);
    }
}

