/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.gapp.importing.DotProductsFinder;
import de.gaalop.gapp.importing.parallelObjects.Constant;
import de.gaalop.gapp.importing.parallelObjects.DotProduct;
import de.gaalop.gapp.importing.parallelObjects.ExtCalculation;
import de.gaalop.gapp.importing.parallelObjects.MvComponent;
import de.gaalop.gapp.importing.parallelObjects.ParVariable;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectVisitor;
import de.gaalop.gapp.importing.parallelObjects.Product;
import de.gaalop.gapp.importing.parallelObjects.Sum;

public class DotProductCreator
implements ParallelObjectVisitor {
    private DotProduct dotProduct;
    private int summandNo;

    private DotProduct processMoreDotProducts(ParallelObject object) {
        DotProductsFinder finder = new DotProductsFinder();
        return (DotProduct)object.accept(finder, null);
    }

    public DotProductCreator(DotProduct dotProduct, int summandNo) {
        this.dotProduct = dotProduct;
        this.summandNo = summandNo;
    }

    @Override
    public Object visitProduct(Product product, Object arg) {
        int vectorNo = 0;
        for (ParallelObject factor : product.getFactors()) {
            this.dotProduct.set(this.summandNo, vectorNo, factor);
            DotProduct newDot = this.processMoreDotProducts(factor);
            if (newDot != null) {
                this.dotProduct.set(this.summandNo, vectorNo, newDot);
            }
            if (product.isNegated()) {
                this.dotProduct.get(this.summandNo, vectorNo).negate();
                product.negate();
            }
            ++vectorNo;
        }
        return null;
    }

    @Override
    public Object visitExtCalculation(ExtCalculation extCalculation, Object arg) {
        DotProduct newDot2;
        this.dotProduct.set(this.summandNo, 0, extCalculation);
        DotProduct newDot = this.processMoreDotProducts(extCalculation.getOperand1());
        if (newDot != null) {
            extCalculation.setOperand1(newDot);
        }
        if (extCalculation.getOperand2() != null && (newDot2 = this.processMoreDotProducts(extCalculation.getOperand2())) != null) {
            extCalculation.setOperand2(newDot2);
        }
        return null;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        this.dotProduct.set(this.summandNo, 0, constant);
        return null;
    }

    @Override
    public Object visitMvComponent(MvComponent mvComponent, Object arg) {
        this.dotProduct.set(this.summandNo, 0, mvComponent);
        return null;
    }

    @Override
    public Object visitVariable(ParVariable variable, Object arg) {
        this.dotProduct.set(this.summandNo, 0, variable);
        return null;
    }

    @Override
    public Object visitSum(Sum sum, Object arg) {
        throw new IllegalStateException("Sums are here not allowed");
    }

    @Override
    public Object visitDotProduct(DotProduct dotProduct, Object arg) {
        throw new IllegalStateException("DotProducts are here not allowed");
    }
}

