/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.gapp.importing.DotProductCreator;
import de.gaalop.gapp.importing.parallelObjects.Constant;
import de.gaalop.gapp.importing.parallelObjects.DotProduct;
import de.gaalop.gapp.importing.parallelObjects.ExtCalculation;
import de.gaalop.gapp.importing.parallelObjects.MvComponent;
import de.gaalop.gapp.importing.parallelObjects.ParVariable;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectVisitor;
import de.gaalop.gapp.importing.parallelObjects.Product;
import de.gaalop.gapp.importing.parallelObjects.Sum;
import java.util.LinkedList;

public class DotProductsFinder
implements ParallelObjectVisitor {
    @Override
    public Object visitSum(Sum sum, Object arg) {
        DotProduct dotProduct = new DotProduct();
        int summandNo = 0;
        for (ParallelObject summand : sum.getSummands()) {
            DotProductCreator creator = new DotProductCreator(dotProduct, summandNo);
            summand.accept(creator, null);
            ++summandNo;
        }
        if (sum.isNegated()) {
            dotProduct.negate();
        }
        return dotProduct;
    }

    @Override
    public Object visitProduct(Product product, Object arg) {
        LinkedList<ParallelObject> toRemove = new LinkedList<ParallelObject>();
        LinkedList<DotProduct> toAdd = new LinkedList<DotProduct>();
        for (ParallelObject parallelObject : product.getFactors()) {
            DotProduct dp = (DotProduct)parallelObject.accept(this, null);
            if (dp == null) continue;
            toRemove.add(parallelObject);
            toAdd.add(dp);
        }
        for (ParallelObject parallelObject : toAdd) {
            product.getFactors().add(parallelObject);
        }
        for (ParallelObject parallelObject : toRemove) {
            product.getFactors().remove(parallelObject);
        }
        return null;
    }

    @Override
    public Object visitExtCalculation(ExtCalculation extCalculation, Object arg) {
        DotProduct dp2;
        DotProduct dp1 = (DotProduct)extCalculation.getOperand1().accept(this, null);
        if (dp1 != null) {
            extCalculation.setOperand1(dp1);
        }
        if (extCalculation.getOperand2() != null && (dp2 = (DotProduct)extCalculation.getOperand2().accept(this, null)) != null) {
            extCalculation.setOperand2(dp2);
        }
        return null;
    }

    @Override
    public Object visitVariable(ParVariable variable, Object arg) {
        return null;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return null;
    }

    @Override
    public Object visitMvComponent(MvComponent mvComponent, Object arg) {
        return null;
    }

    @Override
    public Object visitDotProduct(DotProduct dotProduct, Object arg) {
        throw new IllegalStateException("DotProducts are here not allowed");
    }
}

