/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;

public class ReplaceVisitor
extends EmptyControlFlowVisitor
implements ExpressionVisitor {
    private Variable search;
    private MultivectorComponent toReplace;
    private boolean replace;

    public ReplaceVisitor(Variable search, MultivectorComponent toReplace) {
        this.search = search;
        this.toReplace = toReplace;
        this.replace = false;
    }

    public void visit(AssignmentNode node) {
        node.getValue().accept((ExpressionVisitor)this);
        if (this.replace) {
            node.setValue((Expression)this.toReplace);
            this.replace = false;
        }
        super.visit(node);
    }

    private void visitBinaryOperation(BinaryOperation binaryOperation) {
        binaryOperation.getLeft().accept((ExpressionVisitor)this);
        if (this.replace) {
            binaryOperation.setLeft((Expression)this.toReplace);
            this.replace = false;
        }
        binaryOperation.getRight().accept((ExpressionVisitor)this);
        if (this.replace) {
            binaryOperation.setRight((Expression)this.toReplace);
            this.replace = false;
        }
    }

    private void visitUnaryOperation(UnaryOperation unaryOperation) {
        unaryOperation.getOperand().accept((ExpressionVisitor)this);
        if (this.replace) {
            unaryOperation.setOperand((Expression)this.toReplace);
            this.replace = false;
        }
    }

    public void visit(Subtraction node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(Addition node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(Division node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(InnerProduct node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(Multiplication node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(MathFunctionCall node) {
        this.visitUnaryOperation((UnaryOperation)node);
    }

    public void visit(Variable node) {
        if (node.getName().equals(this.search.getName())) {
            this.replace = true;
        }
    }

    public void visit(MultivectorComponent node) {
    }

    public void visit(Exponentiation node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(FloatConstant node) {
    }

    public void visit(OuterProduct node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(BaseVector node) {
    }

    public void visit(Negation node) {
        this.visitUnaryOperation((UnaryOperation)node);
    }

    public void visit(Reverse node) {
        this.visitUnaryOperation((UnaryOperation)node);
    }

    public void visit(LogicalOr node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(LogicalAnd node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(LogicalNegation node) {
        this.visitUnaryOperation((UnaryOperation)node);
    }

    public void visit(Equality node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(Inequality node) {
        this.visitBinaryOperation((BinaryOperation)node);
    }

    public void visit(Relation relation) {
        this.visitBinaryOperation((BinaryOperation)relation);
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been inlined");
    }
}

