/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing.optimization;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.EndNode;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.visitor.EmptyCFGGAPPVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class GAPPSetMvMerger
extends EmptyCFGGAPPVisitor {
    private HashSet<GAPPSetMv> toRemove = new HashSet();
    private String curDestination;
    private HashMap<String, LinkedList<GAPPSetMv>> mapSetMv = new HashMap();

    public HashSet<GAPPSetMv> getToRemove() {
        return this.toRemove;
    }

    public void visit(AssignmentNode node) {
        String varName = node.getVariable().getName();
        if (this.curDestination != null && !this.curDestination.equals(varName)) {
            this.prepareMap();
            this.mapSetMv.clear();
        }
        this.curDestination = varName;
        super.visit(node);
    }

    public void visit(EndNode node) {
        if (!this.mapSetMv.isEmpty()) {
            this.prepareMap();
            this.mapSetMv.clear();
        }
        super.visit(node);
    }

    private void prepareMap() {
        for (LinkedList<GAPPSetMv> list : this.mapSetMv.values()) {
            if (list.size() <= 1) continue;
            GAPPSetMv first = list.removeFirst();
            for (GAPPSetMv cur : list) {
                first.getSelectorsDest().addAll((Collection)cur.getSelectorsDest());
                first.getSelectorsSrc().addAll((Collection)cur.getSelectorsSrc());
            }
            this.toRemove.addAll(list);
        }
    }

    public Object visitSetMv(GAPPSetMv gappSetMv, Object arg) {
        if (gappSetMv.getDestination().getName().equals(this.curDestination)) {
            String src = gappSetMv.getSource().getName();
            if (!this.mapSetMv.containsKey(src)) {
                this.mapSetMv.put(src, new LinkedList());
            }
            this.mapSetMv.get(src).add(gappSetMv);
        }
        return super.visitSetMv(gappSetMv, arg);
    }
}

