/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing.parallelObjects;

import de.gaalop.gapp.importing.ParallelVector;
import de.gaalop.gapp.importing.parallelObjects.Constant;
import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectVisitor;
import java.util.LinkedList;

public class DotProduct
extends ParallelObject {
    private LinkedList<ParallelVector> factors = new LinkedList();
    private int width = 0;
    private int height = 0;

    @Override
    public Object accept(ParallelObjectVisitor visitor, Object arg) {
        return visitor.visitDotProduct(this, arg);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder((this.isNegated() ? "!" : "") + "[");
        if (this.width > 0) {
            for (ParallelVector vector : this.factors) {
                result.append("(");
                result.append(vector.toString());
                result.append("),");
            }
            result.deleteCharAt(result.length() - 1);
        }
        result.append("]");
        return result.toString();
    }

    public void ensure(int row, int col) {
        while (col >= this.width) {
            this.addCol();
        }
        while (row >= this.height) {
            this.addRow();
        }
    }

    private void addCol() {
        ParallelVector vector = new ParallelVector();
        for (int y = 0; y < this.height; ++y) {
            vector.getSlots().add(new Constant(1.0));
        }
        this.factors.add(vector);
        ++this.width;
    }

    private void addRow() {
        for (ParallelVector factor : this.factors) {
            factor.getSlots().add(new Constant(1.0));
        }
        ++this.height;
    }

    public ParallelObject get(int row, int col) {
        return this.factors.get(col).getSlots().get(row);
    }

    public void set(int row, int col, ParallelObject object) {
        this.ensure(row, col);
        this.factors.get(col).getSlots().set(row, object);
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public LinkedList<ParallelVector> getFactors() {
        return this.factors;
    }

    public void computeWidthAndHeight() {
        this.width = this.factors.size();
        this.height = this.width >= 1 ? this.factors.getFirst().getSlots().size() : 0;
    }

    public void setFactors(LinkedList<ParallelVector> factors) {
        this.factors = factors;
    }
}

