/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.importing.parallelObjects;

import de.gaalop.gapp.importing.parallelObjects.ParallelObject;
import de.gaalop.gapp.importing.parallelObjects.ParallelObjectVisitor;
import java.util.LinkedList;

public class Product
extends ParallelObject {
    private LinkedList<ParallelObject> factors;

    public Product() {
        this.factors = new LinkedList();
    }

    public Product(LinkedList<ParallelObject> factors) {
        this.factors = factors;
    }

    public LinkedList<ParallelObject> getFactors() {
        return this.factors;
    }

    public void setFactors(LinkedList<ParallelObject> factors) {
        this.factors = factors;
    }

    @Override
    public Object accept(ParallelObjectVisitor visitor, Object arg) {
        return visitor.visitProduct(this, arg);
    }

    public void add(ParallelObject factor) {
        this.factors.add(factor);
    }

    public void add(Product product) {
        this.factors.addAll(product.getFactors());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder((this.isNegated() ? "!" : "") + "(");
        for (ParallelObject obj : this.factors) {
            sb.append(obj.toString());
            sb.append(" *");
        }
        if (this.factors.size() >= 1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isTerminal() {
        return false;
    }
}

