/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gapp.statistics;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.gapp.PairSetOfVariablesAndIndices;
import de.gaalop.gapp.SetVectorArgument;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMvCoeff;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.statistics.Interval;
import de.gaalop.gapp.statistics.LiveStatistics;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPSetOfVariables;
import de.gaalop.gapp.visitor.CFGGAPPVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class MemoryUsage
extends CFGGAPPVisitor {
    private HashMap<String, LiveStatistics> liveStatistics = new HashMap();
    private int curLine = 0;

    private MemoryUsage() {
    }

    public static void printMemoryUsage(ControlFlowGraph graph) {
        MemoryUsage visitor = new MemoryUsage();
        graph.accept((ControlFlowVisitor)visitor);
        System.out.println("#Instructions: " + visitor.curLine);
        System.out.println("#Multivectors: " + visitor.liveStatistics.size());
        long sum = 0L;
        for (LiveStatistics live : visitor.liveStatistics.values()) {
            sum += (long)live.getSize();
        }
        System.out.println("Sum of multivectors sizes (liveness start until end): " + sum);
        System.out.println("Maximum of used space: " + visitor.maximumUsedSpace());
    }

    private long maximumUsedSpace() {
        return this.maximumUsedSpaceDivAndConq(1, this.curLine, this.liveStatistics.values());
    }

    private long maximumUsedSpaceDivAndConq(int lineStart, int lineEnd, Collection<LiveStatistics> list) {
        if (list.isEmpty()) {
            return 0L;
        }
        if (lineEnd - lineStart == 0) {
            long sum = 0L;
            for (LiveStatistics stat : list) {
                sum += (long)stat.getSize();
            }
            return sum;
        }
        int centerlastIntLeft = (lineStart + lineEnd) / 2;
        LinkedList<LiveStatistics> leftList = new LinkedList<LiveStatistics>();
        LinkedList<LiveStatistics> rightList = new LinkedList<LiveStatistics>();
        for (LiveStatistics element : list) {
            Interval interval = element.getInterval();
            int from = interval.getFrom();
            int to = interval.getTo();
            if (from <= centerlastIntLeft) {
                leftList.add(element);
                if (to <= centerlastIntLeft) continue;
                rightList.add(element);
                continue;
            }
            rightList.add(element);
        }
        long leftMax = this.maximumUsedSpaceDivAndConq(lineStart, centerlastIntLeft, leftList);
        long rightMax = this.maximumUsedSpaceDivAndConq(centerlastIntLeft + 1, lineEnd, rightList);
        return Math.max(leftMax, rightMax);
    }

    private void access(GAPPSetOfVariables gappSetOfVariables) {
        if (!this.liveStatistics.containsKey(gappSetOfVariables.getName())) {
            System.err.println("Multivector " + gappSetOfVariables.getName() + " was not reseted!");
        } else {
            this.liveStatistics.get(gappSetOfVariables.getName()).getInterval().setTo(this.curLine);
        }
    }

    public Object visitAssignMv(GAPPAssignMv gappAssignMv, Object arg) {
        ++this.curLine;
        this.access((GAPPSetOfVariables)gappAssignMv.getDestination());
        return null;
    }

    public Object visitDotVectors(GAPPDotVectors gappDotVectors, Object arg) {
        ++this.curLine;
        this.access((GAPPSetOfVariables)gappDotVectors.getDestination());
        return null;
    }

    public Object visitResetMv(GAPPResetMv gappResetMv, Object arg) {
        ++this.curLine;
        this.liveStatistics.put(gappResetMv.getDestination().getName(), new LiveStatistics(this.curLine, gappResetMv.getSize()));
        return null;
    }

    public Object visitSetMv(GAPPSetMv gappSetMv, Object arg) {
        ++this.curLine;
        this.access((GAPPSetOfVariables)gappSetMv.getDestination());
        this.access(gappSetMv.getSource());
        return null;
    }

    public Object visitSetVector(GAPPSetVector gappSetVector, Object arg) {
        ++this.curLine;
        for (SetVectorArgument curArg : gappSetVector.getEntries()) {
            if (curArg.isConstant()) continue;
            PairSetOfVariablesAndIndices p = (PairSetOfVariablesAndIndices)curArg;
            this.access(p.getSetOfVariable());
        }
        return null;
    }

    public Object visitCalculateMv(GAPPCalculateMv gappCalculateMv, Object arg) {
        ++this.curLine;
        this.access((GAPPSetOfVariables)gappCalculateMv.getDestination());
        this.access((GAPPSetOfVariables)gappCalculateMv.getOperand1());
        if (gappCalculateMv.getOperand2() != null) {
            this.access((GAPPSetOfVariables)gappCalculateMv.getOperand2());
        }
        return null;
    }

    public Object visitCalculateMvCoeff(GAPPCalculateMvCoeff gappCalculateMvCoeff, Object arg) {
        ++this.curLine;
        this.access((GAPPSetOfVariables)new GAPPMultivector(gappCalculateMvCoeff.getDestination().getName()));
        this.access((GAPPSetOfVariables)gappCalculateMvCoeff.getOperand1());
        if (gappCalculateMvCoeff.getOperand2() != null) {
            this.access((GAPPSetOfVariables)gappCalculateMvCoeff.getOperand2());
        }
        return null;
    }

    public Object visitAssignInputsVector(GAPPAssignInputsVector gAPPAssignInputsVector, Object arg) {
        ++this.curLine;
        this.access((GAPPSetOfVariables)new GAPPMultivector("inputsVector"));
        return null;
    }
}

