/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.latex;

import de.gaalop.CodeGenerator;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.latex.LatexVisitor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public enum LatexCodeGenerator implements CodeGenerator
{
    INSTANCE;


    public Set<OutputFile> generate(ControlFlowGraph in) {
        String code = this.generateCode(in);
        String filename = this.generateFilename(in);
        OutputFile sourceFile = new OutputFile(filename, code, Charset.forName("UTF-8"));
        return Collections.singleton(sourceFile);
    }

    private String generateFilename(ControlFlowGraph in) {
        String filename = "gaalop.tex";
        if (in.getSource() != null) {
            filename = in.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + ".tex";
        }
        return filename;
    }

    private String generateCode(ControlFlowGraph in) {
        LatexVisitor visitor = new LatexVisitor();
        in.accept((ControlFlowVisitor)visitor);
        return visitor.getCode();
    }
}

