/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappopencl;

import de.gaalop.CodeGenerator;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.gappopencl.GAPPMvSizeVisitor;
import de.gaalop.gappopencl.GAPPOpenCLVisitor;
import de.gaalop.gappopencl.Plugin;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public class GAPPOpenCLCodeGenerator
implements CodeGenerator {
    public static Integer numBlocks = -1;
    public static final String inputsVector = "inputsVector";
    public static final String tempMv = "tempmv";
    public static final String dot = "dot";
    private final Plugin plugin;

    GAPPOpenCLCodeGenerator(Plugin plugin) {
        this.plugin = plugin;
    }

    public static String getVarName(String mvName) {
        if (mvName.startsWith(tempMv) || mvName.startsWith(dot) || mvName.startsWith(inputsVector)) {
            return mvName + "_" + numBlocks;
        }
        return mvName;
    }

    public Set<OutputFile> generate(ControlFlowGraph in) {
        String code = this.generateCode(in);
        String filename = this.generateFilename(in);
        OutputFile sourceFile = new OutputFile(filename, code, Charset.forName("UTF-8"));
        return Collections.singleton(sourceFile);
    }

    private String generateFilename(ControlFlowGraph in) {
        String filename = "gaalop.c";
        if (in.getSource() != null) {
            filename = in.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + ".c";
        }
        return filename;
    }

    private String generateCode(ControlFlowGraph in) {
        numBlocks = numBlocks + 1;
        GAPPMvSizeVisitor mvSizeVisitor = new GAPPMvSizeVisitor();
        try {
            in.accept((ControlFlowVisitor)mvSizeVisitor);
        }
        catch (Throwable error) {
            this.plugin.notifyError(error);
        }
        GAPPOpenCLVisitor visitor = new GAPPOpenCLVisitor(mvSizeVisitor.getMvSizes());
        try {
            in.accept((ControlFlowVisitor)visitor);
        }
        catch (Throwable error) {
            this.plugin.notifyError(error);
        }
        return visitor.getCode();
    }
}

