/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappopencl;

import de.gaalop.gapp.ConstantSetVectorArgument;
import de.gaalop.gapp.PairSetOfVariablesAndIndices;
import de.gaalop.gapp.PosSelector;
import de.gaalop.gapp.Selector;
import de.gaalop.gapp.SelectorIndex;
import de.gaalop.gapp.SetVectorArgument;
import de.gaalop.gapp.instructionSet.CalculationType;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPCalculateMvCoeff;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.variables.GAPPConstant;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.variables.GAPPMultivectorComponent;
import de.gaalop.gapp.variables.GAPPScalarVariable;
import de.gaalop.gapp.variables.GAPPValueHolder;
import de.gaalop.gapp.variables.GAPPVariableVisitor;
import de.gaalop.gapp.variables.GAPPVector;
import de.gaalop.gapp.visitor.CFGGAPPVisitor;
import de.gaalop.gappopencl.GAPPOpenCLCodeGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class GAPPOpenCLVisitor
extends CFGGAPPVisitor
implements GAPPVariableVisitor {
    protected static int dotCount = 0;
    protected static final String lo = ".lo";
    protected static final String hi = ".hi";
    protected static final int maxOpenCLVectorSize = 16;
    protected Map<String, Integer> mvSizes;
    protected boolean gpcMetaInfo = true;
    protected Map<String, Map<Integer, String>> mvBladeMap = new HashMap<String, Map<Integer, String>>();
    protected StringBuilder result = new StringBuilder();

    public GAPPOpenCLVisitor(Map<String, Integer> mvSizes) {
        this.mvSizes = mvSizes;
    }

    public Object visitResetMv(GAPPResetMv gappResetMv, Object arg) {
        String destMv = GAPPOpenCLCodeGenerator.getVarName(gappResetMv.getDestination().getName());
        if (this.gpcMetaInfo && !destMv.startsWith("tempmv")) {
            this.result.append("//#pragma gpc multivector ").append(destMv).append("\n");
        }
        this.printOpenCLVectorType(this.computeNearestOpenCLVectorSize(this.mvSizes.get(destMv)));
        this.result.append(" ");
        this.result.append(destMv).append(";\n");
        this.mvBladeMap.put(destMv, new HashMap());
        return null;
    }

    public Object visitSetMv(GAPPSetMv gappSetMv, Object arg) {
        String destMv = GAPPOpenCLCodeGenerator.getVarName(gappSetMv.getDestination().getName());
        Integer thisMvSetCount = this.mvBladeMap.get(destMv).size();
        int selCount = 0;
        for (PosSelector sel : gappSetMv.getSelectorsDest()) {
            this.declareGPCMultivectorComponent(destMv, thisMvSetCount, (SelectorIndex)sel);
            String bladeCoeff = this.getBladeCoeff(destMv, thisMvSetCount);
            this.result.append(bladeCoeff);
            this.result.append(" = ");
            if (((Selector)gappSetMv.getSelectorsSrc().get(0)).getSign() < 0) {
                this.result.append("-");
            }
            this.result.append(this.mvBladeMap.get(GAPPOpenCLCodeGenerator.getVarName(gappSetMv.getSource().getName())).get(((Selector)gappSetMv.getSelectorsSrc().get(selCount++)).getIndex()));
            this.result.append(";\n");
            this.mvBladeMap.get(destMv).put(sel.getIndex(), bladeCoeff);
            thisMvSetCount = thisMvSetCount + 1;
        }
        return null;
    }

    protected String getBladeCoeff(String mv, int blade) {
        return mv + (this.mvSizes.get(mv) == 1 ? "" : ".s" + this.getOpenCLIndex(blade));
    }

    protected static String formatBladeName(String bladeName) {
        if (bladeName.equals("1.0") || bladeName.equals("1.0f")) {
            return "1";
        }
        StringTokenizer tokenizer = new StringTokenizer(bladeName, " \t\n\r\f()");
        StringBuilder bladeBuffer = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            bladeBuffer.append(tokenizer.nextToken());
        }
        return bladeBuffer.toString();
    }

    protected void declareGPCMultivectorComponent(String mv, Integer blade, SelectorIndex sel) {
        if (!this.gpcMetaInfo || mv.startsWith("tempmv")) {
            return;
        }
        this.result.append("//#pragma gpc multivector_component ");
        this.result.append(mv);
        this.result.append(" ").append(GAPPOpenCLVisitor.formatBladeName(sel.getBladeName()));
        this.result.append(" ").append(mv);
        if (this.mvSizes.get(mv) > 1) {
            this.result.append(".s").append(blade);
        }
        this.result.append("\n");
    }

    public Object visitSetVector(GAPPSetVector gappSetVector, Object arg) {
        int wholeVectorSize = 0;
        for (SetVectorArgument setVectorArg : gappSetVector.getEntries()) {
            if (setVectorArg.isConstant()) {
                ++wholeVectorSize;
                continue;
            }
            wholeVectorSize += ((PairSetOfVariablesAndIndices)setVectorArg).getSelectors().size();
        }
        String destVecBase = GAPPOpenCLCodeGenerator.getVarName(gappSetVector.getDestination().getName());
        ArrayList<String> entries = new ArrayList<String>();
        for (SetVectorArgument setVectorArg : gappSetVector.getEntries()) {
            if (setVectorArg.isConstant()) {
                entries.add(String.valueOf(((ConstantSetVectorArgument)setVectorArg).getValue()));
                continue;
            }
            PairSetOfVariablesAndIndices pair = (PairSetOfVariablesAndIndices)setVectorArg;
            Iterator itSelector = pair.getSelectors().iterator();
            while (itSelector.hasNext()) {
                entries.add(this.visitSelector((Selector)itSelector.next(), GAPPOpenCLCodeGenerator.getVarName(pair.getSetOfVariable().getName())));
            }
        }
        HashMap<Integer, String> bladeMap = new HashMap<Integer, String>();
        Iterator itEntries = entries.iterator();
        int vectorSizeRemainder = wholeVectorSize;
        int subvectorIndex = 0;
        int bladeGlobalIndex = 0;
        do {
            int openCLVectorSize = this.computeNearestOpenCLVectorSize(vectorSizeRemainder);
            String destVec = destVecBase + "_" + subvectorIndex;
            this.printOpenCLVectorType(openCLVectorSize);
            this.result.append(" ");
            this.result.append(destVec);
            this.result.append(" = (");
            this.printOpenCLVectorType(openCLVectorSize);
            this.result.append(")(");
            int bladeLocalIndex = 0;
            if (itEntries.hasNext()) {
                this.result.append((String)itEntries.next());
            }
            while (true) {
                int n = ++bladeLocalIndex;
                ++bladeLocalIndex;
                if (n >= openCLVectorSize || !itEntries.hasNext()) break;
                this.result.append(",");
                this.result.append((String)itEntries.next());
            }
            assert (bladeLocalIndex > 0);
            while (bladeLocalIndex++ < openCLVectorSize) {
                this.result.append(",0");
            }
            this.result.append(");\n");
            for (bladeLocalIndex = 0; bladeLocalIndex < openCLVectorSize; ++bladeLocalIndex) {
                bladeMap.put(bladeGlobalIndex++, destVec + ".s" + bladeLocalIndex);
            }
            this.mvBladeMap.put(destVecBase, bladeMap);
            ++subvectorIndex;
        } while ((vectorSizeRemainder -= 16) > 0);
        return null;
    }

    protected void printOpenCLVectorType(int openCLVectorSize) {
        this.result.append("float");
        if (openCLVectorSize != 1) {
            this.result.append(openCLVectorSize);
        }
    }

    protected String visitSelector(Selector sel, String sourceName) {
        String lookupBladeCoeff;
        StringBuilder out = new StringBuilder();
        if (sel.getSign() < 0) {
            out.append("-");
        }
        if ((lookupBladeCoeff = this.mvBladeMap.get(sourceName).get(sel.getIndex())) == null) {
            if (sourceName.equals("1.0")) {
                out.append("1");
            } else {
                out.append(sourceName);
            }
        } else {
            out.append(lookupBladeCoeff);
        }
        return out.toString();
    }

    public Object visitCalculateMv(GAPPCalculateMv gappCalculateMv, Object arg) {
        return null;
    }

    protected int computeNearestOpenCLVectorSize(int in) {
        if (in <= 0) {
            return -1;
        }
        if (in == 1) {
            return in;
        }
        if (in == 2) {
            return in;
        }
        if (in <= 4) {
            return 4;
        }
        if (in <= 8) {
            return 8;
        }
        return 16;
    }

    protected String getOpenCLIndex(Integer index) {
        if (index < 10) {
            return index.toString();
        }
        switch (index) {
            case 10: {
                return "a";
            }
            case 11: {
                return "b";
            }
            case 12: {
                return "c";
            }
            case 13: {
                return "d";
            }
            case 14: {
                return "e";
            }
            case 15: {
                return "f";
            }
        }
        assert (false);
        return "fail";
    }

    public Object visitCalculateMvCoeff(GAPPCalculateMvCoeff gappCalculateMvCoeff, Object arg) {
        String destMv = GAPPOpenCLCodeGenerator.getVarName(gappCalculateMvCoeff.getDestination().getName());
        Integer thisMvSetCount = this.mvBladeMap.get(destMv).size();
        String bladeCoeff = this.getBladeCoeff(destMv, thisMvSetCount);
        this.result.append(bladeCoeff);
        this.result.append(" = ");
        this.visitCalculateOp(gappCalculateMvCoeff.getType(), GAPPOpenCLCodeGenerator.getVarName(gappCalculateMvCoeff.getOperand1().getName()), GAPPOpenCLCodeGenerator.getVarName(gappCalculateMvCoeff.getOperand2().getName()));
        this.result.append(";\n");
        this.mvBladeMap.get(destMv).put(gappCalculateMvCoeff.getDestination().getBladeIndex(), bladeCoeff);
        return null;
    }

    protected void visitCalculateOp(CalculationType type, String operand1, String operand2) {
        switch (type) {
            case DIVISION: {
                this.result.append("(");
                this.result.append(operand1);
                this.result.append(") / (");
                this.result.append(operand2);
                this.result.append(")");
                break;
            }
            case ABS: {
                this.result.append("abs(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case ACOS: {
                this.result.append("acos(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case ASIN: {
                this.result.append("asin(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case ATAN: {
                this.result.append("atan(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case CEIL: {
                this.result.append("ceil(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case COS: {
                this.result.append("cos(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case FLOOR: {
                this.result.append("floor(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case LOG: {
                this.result.append("log(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case SIN: {
                this.result.append("sin(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case SQRT: {
                this.result.append("sqrt(");
                this.result.append(operand1);
                this.result.append(")");
                break;
            }
            case TAN: {
                this.result.append("tan(");
                this.result.append(operand1);
                this.result.append(")");
            }
        }
    }

    public Object visitAssignMv(GAPPAssignMv gappAssignMv, Object arg) {
        String destMv = GAPPOpenCLCodeGenerator.getVarName(gappAssignMv.getDestination().getName());
        Integer thisMvSetCount = this.mvBladeMap.get(destMv).size();
        int selCount = 0;
        for (GAPPValueHolder val : gappAssignMv.getValues()) {
            String bladeCoeff = this.getBladeCoeff(destMv, thisMvSetCount);
            this.result.append(bladeCoeff);
            this.result.append(" = ");
            this.result.append(val.toString());
            this.result.append(";\n");
            this.mvBladeMap.get(destMv).put(((PosSelector)gappAssignMv.getSelectors().get(selCount++)).getIndex(), bladeCoeff);
            thisMvSetCount = thisMvSetCount + 1;
        }
        return null;
    }

    public Object visitDotVectors(GAPPDotVectors gappDotVectors, Object arg) {
        int openCLVectorSize;
        String destMv = GAPPOpenCLCodeGenerator.getVarName(gappDotVectors.getDestination().getName());
        Integer thisMvSetCount = this.mvBladeMap.get(destMv).size();
        this.declareGPCMultivectorComponent(destMv, thisMvSetCount, (SelectorIndex)gappDotVectors.getDestSelector());
        String bladeCoeff = this.getBladeCoeff(destMv, thisMvSetCount);
        this.mvBladeMap.get(destMv).put(gappDotVectors.getDestSelector().getIndex(), bladeCoeff);
        int operandSize = this.mvBladeMap.get(GAPPOpenCLCodeGenerator.getVarName(((GAPPVector)gappDotVectors.getParts().get(0)).getName())).size();
        if (operandSize == 1) {
            this.result.append(bladeCoeff).append(" = ");
            this.visitDotVectorsParallelMultiply(gappDotVectors, 0);
            return null;
        }
        int multiplyDotCount = dotCount;
        int operandSizeRemainder = operandSize;
        int subvectorIndex = 0;
        do {
            openCLVectorSize = this.computeNearestOpenCLVectorSize(operandSizeRemainder);
            this.printOpenCLVectorType(openCLVectorSize);
            this.result.append(" ").append("dot").append(multiplyDotCount);
            this.result.append("_").append(subvectorIndex);
            this.result.append(" = ");
            this.visitDotVectorsParallelMultiply(gappDotVectors, subvectorIndex);
            ++subvectorIndex;
        } while ((operandSizeRemainder -= openCLVectorSize) > 0);
        openCLVectorSize = this.computeNearestOpenCLVectorSize(operandSize);
        if (operandSize / 16 > 1) {
            assert (openCLVectorSize == 16);
            this.printOpenCLVectorType(16);
            this.result.append(" ").append("dot").append(dotCount + 1);
            this.result.append("_0");
            this.result.append(" = ");
            this.result.append(" ").append("dot").append(dotCount);
            this.result.append("_0");
            operandSizeRemainder = operandSize - openCLVectorSize;
            subvectorIndex = 1;
            while (operandSizeRemainder / 16 > 0) {
                this.result.append(" + ");
                this.result.append(" ").append("dot").append(dotCount);
                this.result.append("_").append(subvectorIndex++);
                operandSizeRemainder -= 16;
            }
            this.result.append(";\n");
        }
        ++dotCount;
        int multiplyIndex = 1;
        openCLVectorSize = this.computeNearestOpenCLVectorSize(operandSize);
        while ((openCLVectorSize >>= 1) > 1) {
            this.printOpenCLVectorType(openCLVectorSize);
            this.result.append(" ").append("dot").append(dotCount + 1);
            this.result.append("_0");
            this.result.append(" = ");
            this.result.append("dot").append(dotCount).append("_0").append(lo);
            this.result.append(" + ");
            this.result.append("dot").append(dotCount).append("_0").append(hi);
            if (operandSize % (openCLVectorSize << 1) / openCLVectorSize > 0) {
                this.result.append(" + ");
                this.result.append("dot").append(multiplyDotCount).append("_").append(multiplyIndex++);
            }
            this.result.append(";\n");
            ++dotCount;
        }
        this.result.append(bladeCoeff);
        this.result.append(" = ");
        this.result.append("dot").append(dotCount).append("_0").append(lo);
        this.result.append(" + ");
        this.result.append("dot").append(dotCount).append("_0").append(hi);
        this.result.append(";\n");
        ++dotCount;
        return null;
    }

    public void visitDotVectorsParallelMultiply(GAPPDotVectors gappDotVectors, int subvectorIndex) {
        Iterator it = gappDotVectors.getParts().iterator();
        this.result.append(((GAPPVector)it.next()).getName());
        this.result.append("_").append(subvectorIndex);
        while (it.hasNext()) {
            this.result.append(" * ");
            this.result.append(((GAPPVector)it.next()).getName());
            this.result.append("_").append(subvectorIndex);
        }
        this.result.append(";\n");
    }

    public void visitWriteMask(int operandSize) {
        this.result.append(".s");
        for (int counter = 0; counter < operandSize; ++counter) {
            this.result.append(this.getOpenCLIndex(counter));
        }
    }

    String getCode() {
        return this.result.toString();
    }

    public Object visitConstant(GAPPConstant gappConstant, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitMultivector(GAPPMultivector gappMultivector, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitMultivectorComponent(GAPPMultivectorComponent gappMultivectorComponent, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitScalarVariable(GAPPScalarVariable gappScalarVariable, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitVector(GAPPVector gappVector, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visitAssignInputsVector(GAPPAssignInputsVector gappAssignInputsVector, Object arg) {
        String inputsArrayName = GAPPOpenCLCodeGenerator.getVarName("inputsVector");
        HashMap<Integer, String> bladeMap = new HashMap<Integer, String>();
        Iterator it = gappAssignInputsVector.getValues().iterator();
        while (it.hasNext()) {
            bladeMap.put(bladeMap.size(), ((GAPPValueHolder)it.next()).prettyPrint());
        }
        this.mvBladeMap.put(inputsArrayName, bladeMap);
        return null;
    }
}

