/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappopencl;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.Notifications;
import de.gaalop.gappopencl.GAPPOpenCLCodeGenerator;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.Observable;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Plugin
extends Observable
implements CodeGeneratorPlugin {
    private Log log = LogFactory.getLog(Plugin.class);
    private Image icon;
    @ConfigurationProperty(type=ConfigurationProperty.Type.BOOLEAN)
    public boolean standalone = true;

    public Plugin() {
        URL url = this.getClass().getResource("icon.png");
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read plugin icon " + url));
            }
        } else {
            this.log.warn((Object)"Unable to find plugin icon!");
        }
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public CodeGenerator createCodeGenerator() {
        return new GAPPOpenCLCodeGenerator(this);
    }

    public String getName() {
        return "GAPP OpenCL";
    }

    public String getDescription() {
        return "This plugin generates C/C++ code.";
    }

    public Image getIcon() {
        return this.icon;
    }

    void notifyError(Throwable error) {
        this.setChanged();
        this.notifyObservers(new Notifications.Error(error));
    }
}

