/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.compressed;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.StartNode;
import de.gaalop.cpp.CppVisitor;
import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompressedVisitor
extends CppVisitor {
    protected Map<String, Integer> mvSizes;
    protected Map<String, Map<Integer, Integer>> mvBladeMap = new HashMap<String, Map<Integer, Integer>>();
    protected boolean gpcMetaInfo = true;

    public CompressedVisitor(Map<String, Integer> mvSizes, boolean standalone, boolean useDouble) {
        super(standalone, useDouble);
        this.mvSizes = mvSizes;
    }

    public void visit(StartNode node) {
        this.graph = node.getGraph();
        List localVariables = this.sortVariables(this.graph.getLocalVariables());
        if (this.standalone) {
            this.code.append("void calculate(");
            List inputParameters = this.sortVariables(this.graph.getInputVariables());
            for (Variable var : inputParameters) {
                this.code.append(this.variableType).append(" ");
                this.code.append(var.getName());
                this.code.append(", ");
            }
            for (Variable var : localVariables) {
                this.code.append(this.variableType).append(" ");
                this.code.append(var.getName());
                if (this.mvSizes.get(var.getName()) > 1) {
                    this.code.append("[" + this.mvSizes.get(var.getName()).toString() + "]");
                }
                this.code.append(";\n");
            }
            if (this.graph.getLocalVariables().size() > 0) {
                this.code.setLength(this.code.length() - 2);
            }
            this.code.append(") {\n");
            ++this.indentation;
        } else {
            for (Variable var : localVariables) {
                if (this.gpcMetaInfo) {
                    this.appendIndentation();
                    this.code.append("//#pragma gpc multivector ");
                    this.code.append(var.getName());
                    this.code.append('\n');
                }
                this.appendIndentation();
                this.code.append(this.variableType).append(" ");
                this.code.append(var.getName());
                if (this.mvSizes.get(var.getName()) > 1) {
                    this.code.append("[" + this.mvSizes.get(var.getName()).toString() + "]");
                }
                this.code.append(";\n");
            }
        }
        if (this.graph.getScalarVariables().size() > 0) {
            this.appendIndentation();
            this.code.append(this.variableType).append(" ");
            for (Variable tmp : this.graph.getScalarVariables()) {
                this.code.append(tmp.getName());
                this.code.append(", ");
            }
            this.code.delete(this.code.length() - 2, this.code.length());
            this.code.append(";\n");
        }
        if (!this.graph.getLocalVariables().isEmpty()) {
            this.code.append("\n");
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode node) {
        if (this.assigned.contains(node.getVariable().getName())) {
            this.log.warn((Object)("Reuse of variable " + node.getVariable().getName() + ". Make sure to reset this variable or use another name."));
            this.code.append("\n");
            this.appendIndentation();
            this.code.append("// Warning: reuse of variable ");
            this.code.append(node.getVariable().getName());
            this.code.append(".\n");
            this.appendIndentation();
            this.code.append("// Make sure to reset this variable or use another name.\n");
            this.assigned.remove(node.getVariable().getName());
        }
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)new MultivectorComponentWriteVisitor());
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(MultivectorComponent component) {
        String name = component.getName().replace("_opt", "");
        int pos = this.mvBladeMap.get(name).get(component.getBladeIndex());
        this.code.append(name);
        if (this.mvSizes.get(name) > 1) {
            this.code.append("[" + pos + "]");
        }
    }

    protected class MultivectorComponentWriteVisitor
    implements ExpressionVisitor {
        protected MultivectorComponentWriteVisitor() {
        }

        public void visit(MultivectorComponent component) {
            String name = component.getName().replace("_opt", "");
            Map<Integer, Integer> bladeMap = CompressedVisitor.this.mvBladeMap.get(component.getName());
            if (bladeMap == null) {
                bladeMap = new HashMap<Integer, Integer>();
            }
            int pos = bladeMap.size();
            String componentName = name;
            if (CompressedVisitor.this.mvSizes.get(name) > 1) {
                componentName = componentName + "[" + pos + "]";
            }
            if (CompressedVisitor.this.gpcMetaInfo) {
                CompressedVisitor.this.code.append("//#pragma gpc multivector_component ");
                CompressedVisitor.this.code.append(component.getName());
                CompressedVisitor.this.code.append(' ');
                String bladeStr = CompressedVisitor.this.graph.getAlgebraDefinitionFile().getBladeString(component.getBladeIndex());
                bladeStr = bladeStr.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(" ", "");
                CompressedVisitor.this.code.append(bladeStr);
                CompressedVisitor.this.code.append(' ');
                CompressedVisitor.this.code.append(componentName);
                CompressedVisitor.this.code.append('\n');
            }
            CompressedVisitor.this.code.append(componentName);
            bladeMap.put(component.getBladeIndex(), pos);
            CompressedVisitor.this.mvBladeMap.put(component.getName(), bladeMap);
        }

        public void visit(Subtraction node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Addition node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Division node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(InnerProduct node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Multiplication node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(MathFunctionCall node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Variable node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Exponentiation node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(FloatConstant node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(OuterProduct node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(BaseVector node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Negation node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Reverse node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(LogicalOr node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(LogicalAnd node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(LogicalNegation node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Equality node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Inequality node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(Relation relation) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(FunctionArgument node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(MacroCall node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

