/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.CodeParserPlugin;
import de.gaalop.CompilationException;
import de.gaalop.CompilerFacade;
import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.OutputFile;
import de.gaalop.Plugin;
import de.gaalop.Plugins;
import de.gaalop.VisualCodeInserterStrategyPlugin;
import de.gaalop.gui.AlgebraChooserItem;
import de.gaalop.gui.ErrorDialog;
import de.gaalop.gui.PanelPluginSelection;
import de.gaalop.gui.ResultForm;
import de.gaalop.gui.SourceFilePanel;
import de.gaalop.gui.StatusBar;
import de.gaalop.gui.util.PluginIconUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompileAction
extends AbstractAction {
    private static final long serialVersionUID = 2110643735874314468L;
    private Log log = LogFactory.getLog(CompileAction.class);
    private final SourceFilePanel sourcePanel;
    private final StatusBar statusBar;
    private PanelPluginSelection panelPluginSelection;

    public CompileAction(SourceFilePanel sourcePanel, StatusBar statusBar, PanelPluginSelection panelPluginSelection) {
        super("To " + panelPluginSelection.getCodeGeneratorPlugin().getName(), PluginIconUtil.getSmallIcon((Plugin)panelPluginSelection.getCodeGeneratorPlugin()));
        this.panelPluginSelection = panelPluginSelection;
        this.sourcePanel = sourcePanel;
        this.statusBar = statusBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AlgebraChooserItem algebraToUse = this.panelPluginSelection.getAlgebraToUse();
        PanelPluginSelection.lastUsedAlgebra = algebraToUse.algebraName;
        PanelPluginSelection.lastUsedAlgebraRessource = algebraToUse.ressource;
        this.statusBar.reset();
        GlobalSettingsStrategyPlugin globalSettingsPlugin = this.panelPluginSelection.getGlobalSettingsStrategyPlugin();
        if (globalSettingsPlugin == null) {
            JOptionPane.showMessageDialog(null, "No GlobalSettings strategy is available. Please install an appropiate plugin.", "No GlobalSettings Strategy Available", 0);
            return;
        }
        VisualCodeInserterStrategyPlugin visualizerPlugin = this.panelPluginSelection.getVisualizerStrategyPlugin();
        if (visualizerPlugin == null) {
            JOptionPane.showMessageDialog(null, "No visualizer strategy is available. Please install an appropiate plugin.", "No Visualizer Strategy Available", 0);
            return;
        }
        AlgebraStrategyPlugin algebraPlugin = this.panelPluginSelection.getAlgebraStrategyPlugin();
        if (algebraPlugin == null) {
            JOptionPane.showMessageDialog(null, "No algebra strategy is available. Please install an appropiate plugin.", "No Algebra Strategy Available", 0);
            return;
        }
        OptimizationStrategyPlugin optimizationPlugin = this.panelPluginSelection.getOptimizationStrategyPlugin();
        if (optimizationPlugin == null) {
            JOptionPane.showMessageDialog(null, "No optimization strategy is available. Please install an appropiate plugin.", "No Optimization Strategy Available", 0);
            return;
        }
        CodeParserPlugin parserPlugin = this.sourcePanel.getParserPlugin();
        AlgebraStrategyPlugin algebra = (AlgebraStrategyPlugin)Plugins.getAlgebraStrategyPlugins().iterator().next();
        String algebraBaseDirectory = "";
        try {
            Field field = algebra.getClass().getField("additionalBaseDirectory");
            algebraBaseDirectory = BeanUtils.getProperty((Object)algebra, (String)field.getName()).trim();
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(PanelPluginSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        final CompilerFacade facade = new CompilerFacade(parserPlugin.createCodeParser(), globalSettingsPlugin.createGlobalSettingsStrategy(), visualizerPlugin.createVisualCodeInserterStrategy(), algebraPlugin.createAlgebraStrategy(), optimizationPlugin.createOptimizationStrategy(), this.panelPluginSelection.getCodeGeneratorPlugin().createCodeGenerator(), algebraToUse.algebraName, algebraToUse.ressource, algebraBaseDirectory);
        facade.addObserver((Observer)this.statusBar);
        Thread compiler = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Set output = facade.compile(CompileAction.this.sourcePanel.getInputFile());
                    if (!output.isEmpty()) {
                        CompileAction.this.displayOutput(output);
                    }
                }
                catch (CompilationException ex) {
                    CompileAction.this.log.error((Object)"Compilation exception", (Throwable)ex);
                    CompileAction.this.statusBar.displayError(ex);
                    ex.printStackTrace();
                    ErrorDialog.show(ex);
                }
            }
        });
        compiler.start();
    }

    private void displayOutput(Set<OutputFile> output) {
        ResultForm resultForm = new ResultForm(output);
        JFrame outputFrame = new JFrame("Compilation Result");
        outputFrame.setDefaultCloseOperation(2);
        outputFrame.setContentPane(resultForm.getContentPane());
        outputFrame.setPreferredSize(new Dimension(640, 480));
        outputFrame.setIconImage(this.getIcon());
        outputFrame.pack();
        outputFrame.setLocationRelativeTo(null);
        outputFrame.setVisible(true);
    }

    public Image getIcon() {
        URL iconUrl = this.getClass().getResource("icon.png");
        if (iconUrl == null) {
            this.log.warn((Object)"Couldn't find application icon.");
            return null;
        }
        try {
            return ImageIO.read(iconUrl);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to load application icon.", (Throwable)e);
            return null;
        }
    }
}

