/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import com.sun.jna.Platform;
import de.gaalop.gui.MainForm;
import de.gaalop.gui.util.PluginConfigurator;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Main {
    private Log log = LogFactory.getLog(Main.class);
    private static final String CONFIG_FILENAME = "gaalop.xml";
    private static final String DEBUG_LOG = "debug.log";
    private static final String LOG_PATTERN = "%d{ISO8601} %-5p [%t] %c: %m%n";
    private MainForm mainForm;

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("-debug")) {
            Main.startLog();
        }
        Main main = new Main();
        main.run();
    }

    private static void startLog() throws IOException {
        PatternLayout layout = new PatternLayout(LOG_PATTERN);
        FileAppender appender = new FileAppender((Layout)layout, DEBUG_LOG, false);
        BasicConfigurator.configure((Appender)appender);
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.ALL);
    }

    public void run() {
        try {
            if (Platform.isWindows()) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mainForm = new MainForm();
        JFrame mainWindow = new JFrame("Gaalop");
        mainWindow.setIconImage(this.getIcon());
        mainWindow.setDefaultCloseOperation(2);
        mainWindow.setContentPane(this.mainForm.getContentPane());
        mainWindow.pack();
        mainWindow.setLocationRelativeTo(null);
        mainWindow.setVisible(true);
        this.loadConfig();
        this.mainForm.panelPluginSelection.refreshAlgebras();
        this.mainForm.loadOpenedFiles();
        mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Main.this.saveConfig();
                Main.this.mainForm.saveOpenedFiles();
            }
        });
    }

    private void loadConfig() {
        Properties config = new Properties();
        if (new File(CONFIG_FILENAME).exists()) {
            try (FileInputStream input = new FileInputStream(CONFIG_FILENAME);){
                config.loadFromXML(input);
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to load configuration file gaalop.xml", (Throwable)e);
            }
            this.log.debug((Object)("Configuration loaded: " + config));
        }
        PluginConfigurator configurator = new PluginConfigurator(config);
        configurator.configureAll(this.mainForm.getStatusBar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig() {
        PluginConfigurator configurator = new PluginConfigurator();
        configurator.readConfiguration();
        Properties config = configurator.getConfiguration();
        try (FileOutputStream out = new FileOutputStream(CONFIG_FILENAME);){
            config.storeToXML(out, "Gaalop Configuration File");
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to save configuration file gaalop.xml", (Throwable)e);
        }
    }

    public Image getIcon() {
        URL iconUrl = this.getClass().getResource("icon.png");
        if (iconUrl == null) {
            this.log.warn((Object)"Couldn't find application icon.");
            return null;
        }
        try {
            return ImageIO.read(iconUrl);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to load application icon.", (Throwable)e);
            return null;
        }
    }
}

