/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.CodeParserPlugin;
import de.gaalop.CompilationException;
import de.gaalop.Plugins;
import de.gaalop.gui.CloseAction;
import de.gaalop.gui.CompileAction;
import de.gaalop.gui.ConfigurationPanel;
import de.gaalop.gui.ErrorDialog;
import de.gaalop.gui.FileState;
import de.gaalop.gui.GaalopLogoFiller;
import de.gaalop.gui.NewFileAction;
import de.gaalop.gui.OpenFileAction;
import de.gaalop.gui.PanelPluginSelection;
import de.gaalop.gui.PluginSorter;
import de.gaalop.gui.SourceFilePanel;
import de.gaalop.gui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainForm {
    private JPanel contentPane;
    private JButton optimizeButton;
    private JButton configureButton;
    private JLabel logoIcon;
    private JTabbedPane tabbedPane;
    private JEditorPane welcomeToGaalopWelcomeEditorPane;
    private JButton newFileButton;
    private JButton openFileButton;
    private JButton saveFileButton;
    private JButton closeButton;
    private StatusBar statusBar;
    public PanelPluginSelection panelPluginSelection;
    private Log log = LogFactory.getLog(MainForm.class);

    public MainForm() {
        this.$$$setupUI$$$();
        this.contentPane.setPreferredSize(new Dimension(900, 480));
        this.optimizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MainForm.this.tabbedPane.getSelectedComponent() instanceof SourceFilePanel) {
                    if (MainForm.this.panelPluginSelection.areConstraintsFulfilled()) {
                        MainForm.this.panelPluginSelection.updateLastUsedPlugins();
                        SourceFilePanel sourcePanel = (SourceFilePanel)MainForm.this.tabbedPane.getSelectedComponent();
                        CompileAction action = new CompileAction(sourcePanel, MainForm.this.statusBar, MainForm.this.panelPluginSelection);
                        action.actionPerformed(event);
                    } else {
                        ErrorDialog.show(new CompilationException(MainForm.this.panelPluginSelection.getErrorMessage()));
                    }
                }
            }
        });
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ConfigurationPanel(MainForm.this.tabbedPane);
            }
        });
        this.newFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu("New File");
                ArrayList plugins = new ArrayList();
                plugins.addAll(Plugins.getCodeParserPlugins());
                Collections.sort(plugins, new PluginSorter());
                for (CodeParserPlugin plugin : plugins) {
                    menu.add(new NewFileAction(plugin, MainForm.this.tabbedPane));
                }
                menu.show(MainForm.this.newFileButton, 0, ((MainForm)MainForm.this).newFileButton.getBounds().height);
            }
        });
        this.saveFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component component = MainForm.this.tabbedPane.getSelectedComponent();
                if (component instanceof SourceFilePanel) {
                    SourceFilePanel sourceFile = (SourceFilePanel)component;
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setSelectedFile(sourceFile.getFile());
                    int result = fileChooser.showSaveDialog(MainForm.this.contentPane);
                    if (result == 0) {
                        MainForm.this.saveToFile(fileChooser.getSelectedFile(), sourceFile);
                    }
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MainForm.this.tabbedPane.getSelectedComponent() instanceof SourceFilePanel) {
                    MainForm.this.saveFileButton.setEnabled(true);
                    MainForm.this.optimizeButton.setEnabled(true);
                    MainForm.this.closeButton.setEnabled(true);
                } else if (MainForm.this.tabbedPane.getSelectedComponent() instanceof ConfigurationPanel) {
                    MainForm.this.saveFileButton.setEnabled(false);
                    MainForm.this.optimizeButton.setEnabled(false);
                    MainForm.this.closeButton.setEnabled(true);
                } else {
                    MainForm.this.saveFileButton.setEnabled(false);
                    MainForm.this.optimizeButton.setEnabled(false);
                    MainForm.this.closeButton.setEnabled(false);
                }
            }
        });
        this.openFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu("Open File");
                ArrayList plugins = new ArrayList();
                plugins.addAll(Plugins.getCodeParserPlugins());
                Collections.sort(plugins, new PluginSorter());
                for (CodeParserPlugin plugin : plugins) {
                    menu.add(new OpenFileAction(plugin, MainForm.this.tabbedPane));
                }
                menu.show(MainForm.this.openFileButton, 0, ((MainForm)MainForm.this).openFileButton.getBounds().height);
            }
        });
        this.closeButton.setAction(new CloseAction(this.tabbedPane));
        this.welcomeToGaalopWelcomeEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL u = e.getURL();
                    try {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                    catch (IOException e1) {
                        MainForm.this.log.error((Object)e1);
                    }
                    catch (URISyntaxException e1) {
                        MainForm.this.log.error((Object)e1);
                    }
                }
            }
        });
        try {
            this.welcomeToGaalopWelcomeEditorPane.read(this.getClass().getResourceAsStream("welcome.html"), (Object)null);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to read welcome document.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File toFile, SourceFilePanel sourceFilePanel) {
        try (PrintWriter printWriter = new PrintWriter(toFile);){
            printWriter.print(sourceFilePanel.getInputFile().getContent());
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)e);
            JOptionPane.showMessageDialog(this.contentPane, "Unable to save to " + toFile.getAbsolutePath() + "\n" + e, "Error", 0);
            return;
        }
        sourceFilePanel.setFile(toFile);
        sourceFilePanel.setSaved();
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void loadOpenedFiles() {
        Preferences prefs = Preferences.userNodeForPackage(MainForm.class);
        int count = prefs.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            String filename = prefs.get("file" + i, "");
            String pluginClass = prefs.get("plugin" + i, "");
            if (filename.isEmpty()) continue;
            File file = new File(filename);
            CodeParserPlugin plugin = this.getParserPluginByName(pluginClass);
            if (plugin != null) {
                String content = this.getContentOfFile(filename);
                if (content == null) continue;
                SourceFilePanel panel = new SourceFilePanel(plugin, file, content);
                this.tabbedPane.add(panel);
                this.tabbedPane.setTabComponentAt(this.tabbedPane.indexOfComponent(panel), panel.getTabLabel());
                continue;
            }
            this.log.warn((Object)("Code Parser Plugin of MRU file not found: " + pluginClass + " file: " + filename));
        }
    }

    private String getContentOfFile(String filename) {
        try {
            String line;
            FileReader fileReader = new FileReader(filename);
            BufferedReader reader = new BufferedReader(fileReader);
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
            return result.toString();
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to open MRU file " + filename), (Throwable)e);
            return null;
        }
    }

    private CodeParserPlugin getParserPluginByName(String pluginClass) {
        for (CodeParserPlugin plugin : Plugins.getCodeParserPlugins()) {
            if (!plugin.getClass().getName().equals(pluginClass)) continue;
            return plugin;
        }
        return null;
    }

    public void saveOpenedFiles() {
        ArrayList<SourceFilePanel> panels = new ArrayList<SourceFilePanel>(this.tabbedPane.getTabCount());
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component component = this.tabbedPane.getComponentAt(i);
            if (!(component instanceof SourceFilePanel)) continue;
            panels.add((SourceFilePanel)component);
        }
        Preferences prefs = Preferences.userNodeForPackage(MainForm.class);
        try {
            prefs.clear();
            int count = 0;
            for (SourceFilePanel panel : panels) {
                if (panel.getFileState() == FileState.UNSAVED) continue;
                File file = panel.getFile();
                prefs.put("file" + count, file.getAbsolutePath());
                CodeParserPlugin plugin = panel.getParserPlugin();
                prefs.put("plugin" + count, plugin.getClass().getName());
                ++count;
            }
            prefs.putInt("count", count);
        }
        catch (BackingStoreException e) {
            this.log.warn((Object)"Unable to save opened files.", (Throwable)e);
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel1, "North");
        this.logoIcon = new JLabel();
        this.logoIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/logo.png")));
        this.logoIcon.setPreferredSize(new Dimension(660, 75));
        this.logoIcon.setText("");
        panel1.add((Component)this.logoIcon, "West");
        GaalopLogoFiller gaalopLogoFiller1 = new GaalopLogoFiller();
        panel1.add((Component)gaalopLogoFiller1, "Center");
        JToolBar toolBar1 = new JToolBar();
        toolBar1.setBorderPainted(true);
        toolBar1.setFloatable(false);
        panel1.add((Component)toolBar1, "South");
        this.newFileButton = new JButton();
        this.newFileButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-new.png")));
        this.newFileButton.setText("New File");
        this.newFileButton.setMnemonic('N');
        this.newFileButton.setDisplayedMnemonicIndex(0);
        toolBar1.add(this.newFileButton);
        this.openFileButton = new JButton();
        this.openFileButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-open.png")));
        this.openFileButton.setText("Open File");
        this.openFileButton.setMnemonic('O');
        this.openFileButton.setDisplayedMnemonicIndex(0);
        toolBar1.add(this.openFileButton);
        this.saveFileButton = new JButton();
        this.saveFileButton.setEnabled(false);
        this.saveFileButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-save.png")));
        this.saveFileButton.setText("Save File");
        this.saveFileButton.setMnemonic('S');
        this.saveFileButton.setDisplayedMnemonicIndex(0);
        toolBar1.add(this.saveFileButton);
        this.closeButton = new JButton();
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/emblem-unreadable.png")));
        this.closeButton.setText("Close File");
        toolBar1.add(this.closeButton);
        JToolBar.Separator toolBar$Separator2 = new JToolBar.Separator();
        toolBar1.add(toolBar$Separator2);
        this.configureButton = new JButton();
        this.configureButton.setEnabled(true);
        this.configureButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/preferences-system.png")));
        this.configureButton.setText("Configure");
        this.configureButton.setMnemonic('C');
        this.configureButton.setDisplayedMnemonicIndex(3);
        toolBar1.add(this.configureButton);
        JToolBar.Separator toolBar$Separator1 = new JToolBar.Separator();
        toolBar1.add(toolBar$Separator1);
        this.optimizeButton = new JButton();
        this.optimizeButton.setEnabled(false);
        this.optimizeButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/applications-system.png")));
        this.optimizeButton.setText("Optimize");
        this.optimizeButton.setMnemonic('I');
        this.optimizeButton.setDisplayedMnemonicIndex(3);
        toolBar1.add(this.optimizeButton);
        this.tabbedPane = new JTabbedPane();
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.panelPluginSelection = new PanelPluginSelection();
        this.contentPane.add((Component)this.panelPluginSelection, "East");
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        this.tabbedPane.addTab("Welcome", panel2);
        this.welcomeToGaalopWelcomeEditorPane = new JEditorPane();
        this.welcomeToGaalopWelcomeEditorPane.setContentType("text/html");
        this.welcomeToGaalopWelcomeEditorPane.setEditable(false);
        this.welcomeToGaalopWelcomeEditorPane.setText("<html>\r\n  <head>\r\n    \r\n  </head>\r\n  <body>\r\n  </body>\r\n</html>\r\n");
        panel2.add((Component)this.welcomeToGaalopWelcomeEditorPane, "Center");
        this.statusBar = new StatusBar();
        this.contentPane.add((Component)this.statusBar, "South");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

