/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.CodeParserPlugin;
import de.gaalop.Plugin;
import de.gaalop.gui.SourceFilePanel;
import de.gaalop.gui.util.PluginIconUtil;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenFileAction
extends AbstractAction {
    private static final long serialVersionUID = 8586884650535842171L;
    private static File lastDirectory = null;
    private Log log = LogFactory.getLog(OpenFileAction.class);
    private CodeParserPlugin plugin;
    private JTabbedPane tabbedPane;

    public OpenFileAction(CodeParserPlugin plugin, JTabbedPane tabbedPanel) {
        super(plugin.getName(), PluginIconUtil.getSmallIcon((Plugin)plugin));
        this.plugin = plugin;
        this.tabbedPane = tabbedPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(lastDirectory);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "CLUCalc files";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".clu");
            }
        });
        try {
            if (fileChooser.showOpenDialog(this.tabbedPane.getParent()) == 0) {
                String content = this.readFile(fileChooser.getSelectedFile());
                lastDirectory = fileChooser.getSelectedFile().getParentFile();
                SourceFilePanel filePanel = new SourceFilePanel(this.plugin, fileChooser.getSelectedFile(), content);
                this.tabbedPane.addTab("", filePanel);
                int indexOfPanel = this.tabbedPane.indexOfComponent(filePanel);
                this.tabbedPane.setTabComponentAt(indexOfPanel, filePanel.getTabLabel());
                this.tabbedPane.setSelectedIndex(indexOfPanel);
            }
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
            JOptionPane.showMessageDialog(this.tabbedPane.getParent(), "Unable to open file " + fileChooser.getSelectedFile() + ".\n" + ex, "Error", 64);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = in.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
        }
        return result.toString();
    }
}

