/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.OutputFile;
import de.gaalop.gui.OutputFilePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultForm {
    private JTabbedPane tabbedPane;
    private JPanel contentPane;
    private Log log = LogFactory.getLog(ResultForm.class);

    public ResultForm(Set<OutputFile> files) {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setBorderPainted(true);
        toolBar.setFloatable(false);
        this.contentPane.add((Component)toolBar, "North");
        JButton saveButton = new JButton("Save file");
        saveButton.setIcon(new ImageIcon(this.getClass().getResource("/de/gaalop/gui/document-save.png")));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component component = ResultForm.this.tabbedPane.getSelectedComponent();
                if (component instanceof OutputFilePane) {
                    OutputFilePane outputFile = (OutputFilePane)component;
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setSelectedFile(new File(outputFile.getFile().getName()));
                    int result = fileChooser.showSaveDialog(ResultForm.this.contentPane);
                    if (result == 0) {
                        ResultForm.this.saveToFile(fileChooser.getSelectedFile(), outputFile);
                    }
                }
            }
        });
        toolBar.add(saveButton);
        this.tabbedPane = new JTabbedPane();
        this.contentPane.add((Component)this.tabbedPane, "Center");
        for (OutputFile file : files) {
            OutputFilePane filePane = new OutputFilePane(file);
            JTextPane textPane = new JTextPane();
            textPane.setFont(Font.getFont("SansSerif"));
            textPane.setText(file.getContent());
            filePane.setViewportView(textPane);
            this.tabbedPane.add(file.getName(), filePane);
        }
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(File toFile, OutputFilePane outputFilePanel) {
        try (PrintWriter printWriter = new PrintWriter(toFile);){
            printWriter.print(outputFilePanel.getFile().getContent());
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)e);
            JOptionPane.showMessageDialog(this.contentPane, "Unable to save to " + toFile.getAbsolutePath() + "\n" + e, "Error", 0);
            return;
        }
    }
}

