/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gui;

import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.CodeParserPlugin;
import de.gaalop.CompilerFacade;
import de.gaalop.Notifications;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.gui.ErrorDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends JPanel
implements Observer {
    private static final long serialVersionUID = -1854594532112610893L;
    private final String spacer = "   ";
    private final JProgressBar progressBar;
    private final JLabel statusLabel;
    private Throwable ex;
    private List<Notifications.Warning> warnings;

    public StatusBar() {
        this.setLayout(new BorderLayout(10, 0));
        this.progressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.statusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StatusBar.this.ex != null) {
                    ErrorDialog.show(StatusBar.this.ex);
                }
                if (StatusBar.this.warnings != null) {
                    StatusBar.this.displayWarnings();
                }
            }
        });
        this.setStatus("Ready");
        this.add((Component)this.statusLabel, "West");
        this.add((Component)this.progressBar, "Center");
        this.add((Component)new JLabel("   "), "East");
    }

    private void setStatus(String status) {
        this.statusLabel.setText("   " + status);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof CodeParserPlugin) {
            this.updateFromCodeParser(arg);
        }
        if (o instanceof OptimizationStrategyPlugin) {
            this.updateFromOptimizer(arg);
        }
        if (o instanceof CompilerFacade) {
            this.updateFromCompilerFacade(arg);
        }
        if (o instanceof CodeGeneratorPlugin) {
            this.updateFromCodeGenerator(arg);
        }
    }

    private void updateFromCodeParser(Object arg) {
    }

    private void updateFromOptimizer(Object arg) {
        if (arg instanceof Notifications.Start) {
            this.progressBar.setValue(0);
        } else if (arg instanceof Notifications.Number) {
            this.progressBar.setMaximum(((Notifications.Number)arg).getValue());
        } else if (arg instanceof Notifications.Error) {
            Throwable ex = ((Notifications.Error)arg).getError();
            this.displayError(ex);
            ErrorDialog.show(ex);
        } else if (arg instanceof Notifications.Progress) {
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        }
    }

    private void updateFromCompilerFacade(Object arg) {
        if (arg instanceof Notifications.Info) {
            this.setStatus(((Notifications.Info)arg).getMessage());
        } else if (arg instanceof Notifications.Finished) {
            this.setStatus("Finished");
            this.progressBar.setValue(this.progressBar.getMaximum());
            if (Notifications.hasWarnings()) {
                this.warnings = Notifications.getWarnings();
                this.setStatus("Finished (click here to see warnings)");
            }
        }
    }

    private void updateFromCodeGenerator(Object arg) {
        if (arg instanceof Notifications.Error) {
            Throwable ex = ((Notifications.Error)arg).getError();
            this.displayError(ex);
            ErrorDialog.show(ex);
        }
    }

    private void displayWarnings() {
        if (this.warnings != null && this.warnings.size() > 0) {
            int n = this.warnings.size();
            int i = 1;
            StringBuilder messages = new StringBuilder();
            for (Notifications.Warning warning : this.warnings) {
                messages.append("Warning " + i++ + " of " + n + ":\n");
                messages.append(warning.getMessage());
                messages.append('\n');
            }
            JOptionPane.showMessageDialog(null, messages.toString(), "Warnings", 2);
        }
    }

    public void reset() {
        this.ex = null;
        this.warnings = null;
        Notifications.clearWarnings();
        this.statusLabel.setForeground(Color.BLACK);
        this.setStatus("Ready");
        this.progressBar.setValue(0);
    }

    public void displayError(Throwable ex) {
        this.ex = ex;
        this.statusLabel.setForeground(Color.RED);
        this.setStatus("Error (click here to see error dialog)");
    }
}

