/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.codegenGapp;

import de.gaalop.CodeGenerator;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.gapp.visitor.PrettyPrint;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public class GAPPCodeGenerator
implements CodeGenerator {
    public Set<OutputFile> generate(ControlFlowGraph in) {
        String code = this.generateCode(in);
        String filename = this.generateFilename(in);
        OutputFile sourceFile = new OutputFile(filename, code, Charset.forName("UTF-8"));
        return Collections.singleton(sourceFile);
    }

    private String generateFilename(ControlFlowGraph in) {
        String filename = "gaalop.gapp";
        if (in.getSource() != null) {
            filename = in.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + ".gapp";
        }
        return filename;
    }

    private String generateCode(ControlFlowGraph in) {
        PrettyPrint printer = new PrettyPrint();
        in.accept((ControlFlowVisitor)printer);
        return printer.getResultString();
    }
}

