/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Setup
extends JFrame {
    private static final String CONFIG_FILE_NAME = "gaalop.xml";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel panelBin = null;
    private JPanel panelJava = null;
    private JTextField tfJava = null;
    private JButton selectJava = null;
    private JTextField tfBin = null;
    private JButton selectBin = null;
    private JPanel panelButtons = null;
    private JButton buttonSave = null;
    private JButton buttonExit = null;
    private JLabel labelBin = null;
    private JLabel labelJava = null;
    private JFileChooser chooser = null;
    private boolean changed;

    public static void main(String[] args) {
        Setup form = new Setup();
        form.setVisible(true);
    }

    public Setup() {
        this.initialize();
        this.chooser = new JFileChooser();
        this.chooser.setFileSelectionMode(1);
        this.read();
    }

    private void initialize() {
        this.setSize(514, 221);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Gaalop Setup");
        this.setDefaultCloseOperation(2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jContentPane.add((Component)this.getPanelJava(), null);
            this.jContentPane.add((Component)this.getPanelBin(), null);
            this.jContentPane.add((Component)this.getPanelButtons(), null);
        }
        return this.jContentPane;
    }

    private JPanel getPanelBin() {
        if (this.panelBin == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            this.labelBin = new JLabel();
            this.labelBin.setText("Please enter the path to the Maple binaries:");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            this.panelBin = new JPanel();
            this.panelBin.setLayout(new GridBagLayout());
            this.panelBin.add((Component)this.getTfBin(), gridBagConstraints2);
            this.panelBin.add((Component)this.getSelectBin(), gridBagConstraints3);
            this.panelBin.add((Component)this.labelBin, gridBagConstraints6);
        }
        return this.panelBin;
    }

    private JPanel getPanelJava() {
        if (this.panelJava == null) {
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.gridy = 0;
            this.labelJava = new JLabel();
            this.labelJava.setText("Please enter the path to the Maple Java directory:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            this.panelJava = new JPanel();
            this.panelJava.setLayout(new GridBagLayout());
            this.panelJava.add((Component)this.getTfJava(), gridBagConstraints);
            this.panelJava.add((Component)this.getSelectJava(), gridBagConstraints1);
            this.panelJava.add((Component)this.labelJava, gridBagConstraints41);
        }
        return this.panelJava;
    }

    private JTextField getTfJava() {
        if (this.tfJava == null) {
            this.tfJava = new JTextField();
            this.tfJava.setPreferredSize(new Dimension(400, 20));
            this.tfJava.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    Setup.this.changed = true;
                }
            });
        }
        return this.tfJava;
    }

    private JButton getSelectJava() {
        if (this.selectJava == null) {
            this.selectJava = new JButton();
            this.selectJava.setText("Select");
            this.selectJava.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int status = Setup.this.chooser.showOpenDialog(Setup.this.selectJava.getParent());
                    if (status == 0) {
                        Setup.this.changed = true;
                        Setup.this.tfJava.setText(Setup.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.selectJava;
    }

    private JTextField getTfBin() {
        if (this.tfBin == null) {
            this.tfBin = new JTextField();
            this.tfBin.setPreferredSize(new Dimension(400, 20));
            this.tfBin.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    Setup.this.changed = true;
                }
            });
        }
        return this.tfBin;
    }

    private JButton getSelectBin() {
        if (this.selectBin == null) {
            this.selectBin = new JButton();
            this.selectBin.setText("Select");
            this.selectBin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int status = Setup.this.chooser.showOpenDialog(Setup.this.selectJava.getParent());
                    if (status == 0) {
                        Setup.this.changed = true;
                        Setup.this.tfBin.setText(Setup.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        return this.selectBin;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(new FlowLayout());
            this.panelButtons.add((Component)this.getButtonSave(), null);
            this.panelButtons.add((Component)this.getButtonExit(), null);
        }
        return this.panelButtons;
    }

    private JButton getButtonSave() {
        if (this.buttonSave == null) {
            this.buttonSave = new JButton();
            this.buttonSave.setText("Save");
            this.buttonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Setup.this.save();
                }
            });
        }
        return this.buttonSave;
    }

    private JButton getButtonExit() {
        if (this.buttonExit == null) {
            this.buttonExit = new JButton();
            this.buttonExit.setText("Exit");
            this.buttonExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Setup.this.changed) {
                        int result = JOptionPane.showConfirmDialog(Setup.this.getContentPane(), "Settings have not been saved. Save now?");
                        if (result == 0) {
                            Setup.this.save();
                        } else if (result == 1) {
                            Setup.this.dispose();
                        }
                    } else {
                        Setup.this.dispose();
                    }
                }
            });
        }
        return this.buttonExit;
    }

    private String getBinKey() throws SecurityException, NoSuchFieldException {
        String className = "de.gaalop.maple.Plugin";
        String bin = "mapleBinaryPath";
        String binKey = className + "." + bin;
        return binKey;
    }

    private String getJavaKey() throws SecurityException, NoSuchFieldException {
        String className = "de.gaalop.maple.Plugin";
        String java = "mapleJavaPath";
        String javaKey = className + "." + java;
        return javaKey;
    }

    private void save() {
        if (this.changed) {
            Properties config = new Properties();
            try {
                config.put(this.getBinKey(), this.tfBin.getText());
                config.put(this.getJavaKey(), this.tfJava.getText());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            try (FileOutputStream fos = new FileOutputStream(CONFIG_FILE_NAME);){
                config.storeToXML(fos, "Gaalop Configuration File");
                System.out.println("Configuration saved to gaalop.xml");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.changed = false;
    }

    private void read() {
        try {
            FileInputStream fis = new FileInputStream(CONFIG_FILE_NAME);
            Properties config = new Properties();
            config.loadFromXML(fis);
            this.tfBin.setText(config.getProperty(this.getBinKey()));
            this.tfJava.setText(config.getProperty(this.getJavaKey()));
        }
        catch (FileNotFoundException e) {
            System.out.println("gaalop.xml not found. No configuration file read.");
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

