/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cli;

import de.gaalop.AlgebraStrategy;
import de.gaalop.AlgebraStrategyPlugin;
import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.CodeParser;
import de.gaalop.CodeParserPlugin;
import de.gaalop.CompilerFacade;
import de.gaalop.GlobalSettingsStrategy;
import de.gaalop.GlobalSettingsStrategyPlugin;
import de.gaalop.InputFile;
import de.gaalop.OptimizationStrategy;
import de.gaalop.OptimizationStrategyPlugin;
import de.gaalop.OutputFile;
import de.gaalop.Plugins;
import de.gaalop.VisualCodeInserterStrategy;
import de.gaalop.VisualCodeInserterStrategyPlugin;
import de.gaalop.algebra.AlStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    private Log log = LogFactory.getLog(Main.class);
    @Option(name="-i", required=true, usage="The input file.")
    private String inputFile;
    @Option(name="-o", required=false, usage="Sets the directory where the output files are created.")
    private String outputDirectory = ".";
    @Option(name="-parser", required=false, usage="Sets the class name of the code parser plugin that should be used.")
    private String codeParserPlugin = "de.gaalop.clucalc.input.Plugin";
    @Option(name="-generator", required=false, usage="Sets the class name of the code generator plugin that should be used.")
    private String codeGeneratorPlugin = "de.gaalop.clucalc.output.Plugin";
    @Option(name="-optimizer", required=false, usage="Sets the class name of the optimization strategy plugin that should be used.")
    private String optimizationStrategyPlugin = "de.gaalop.maple.Plugin";
    @Option(name="-globalSettings", required=false, usage="Sets the class name of the global Settings strategy plugin that should be used.")
    private String globalSettingsStrategyPlugin = "de.gaalop.globalSettings.Plugin";
    @Option(name="-algebra", required=false, usage="Sets the class name of the algebra strategy plugin that should be used.")
    private String algebraStrategyPlugin = "de.gaalop.algebra.Plugin";
    @Option(name="-visualizer", required=false, usage="Sets the class name of the visualizer strategy plugin that should be used.")
    private String visualizerStrategyPlugin = "de.gaalop.visualCodeInserter.Plugin";
    @Option(name="-algebraName", required=true, usage="Sets the name of the algebra that should be used.")
    private String algebraName;
    @Option(name="-algebraBaseDir", required=false, usage="Sets the base directory path of the user-defined algebras.")
    private String algebraBaseDirectory;

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        try {
            parser.parseArgument(args);
            main.run();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }

    public void run() throws Exception {
        this.log.debug((Object)"Starting up compilation process.");
        CompilerFacade compiler = this.createCompiler();
        InputFile inputFile = this.getInputFile();
        Set outputFiles = compiler.compile(inputFile);
        for (OutputFile output : outputFiles) {
            this.writeFile(output);
        }
    }

    private void writeFile(OutputFile output) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.outputDirectory.equals("-")) {
            this.printFileToConsole(output);
        } else {
            File outFile = new File(this.outputDirectory, output.getName());
            PrintWriter writer = new PrintWriter(outFile, output.getEncoding().name());
            writer.print(output.getContent());
            writer.close();
        }
    }

    private void printFileToConsole(OutputFile output) {
        System.out.println("----------------------------------------------------------");
        System.out.println("Output File: " + output.getName());
        System.out.println("----------------------------------------------------------");
        System.out.println(output.getContent());
        System.out.println("----------------------------------------------------------");
    }

    private CompilerFacade createCompiler() {
        CodeParser codeParser = this.createCodeParser();
        GlobalSettingsStrategy globalSettingsStrategy = this.createGlobalSettingsStrategy();
        AlgebraStrategy algebraStrategy = this.createAlgebraStrategy();
        VisualCodeInserterStrategy visualizerStrategy = this.createVisualizerStrategy();
        OptimizationStrategy optimizationStrategy = this.createOptimizationStrategy();
        CodeGenerator codeGenerator = this.createCodeGenerator();
        boolean asRessource = false;
        try {
            String line;
            InputStream inputStream = AlStrategy.class.getResourceAsStream("algebra/definedAlgebras.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                if (!line.trim().equals(this.algebraName.trim())) continue;
                asRessource = true;
            }
            reader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new CompilerFacade(codeParser, globalSettingsStrategy, visualizerStrategy, algebraStrategy, optimizationStrategy, codeGenerator, this.algebraName, asRessource, this.algebraBaseDirectory);
    }

    private CodeParser createCodeParser() {
        Set plugins = Plugins.getCodeParserPlugins();
        for (CodeParserPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.codeParserPlugin)) continue;
            return plugin.createCodeParser();
        }
        System.err.println("Unknown code parser plugin: " + this.codeParserPlugin);
        System.exit(-2);
        return null;
    }

    private GlobalSettingsStrategy createGlobalSettingsStrategy() {
        Set plugins = Plugins.getGlobalSettingsStrategyPlugins();
        for (GlobalSettingsStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.globalSettingsStrategyPlugin)) continue;
            return plugin.createGlobalSettingsStrategy();
        }
        System.err.println("Unknown algebra strategy plugin: " + this.algebraStrategyPlugin);
        System.exit(-3);
        return null;
    }

    private AlgebraStrategy createAlgebraStrategy() {
        Set plugins = Plugins.getAlgebraStrategyPlugins();
        for (AlgebraStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.algebraStrategyPlugin)) continue;
            return plugin.createAlgebraStrategy();
        }
        System.err.println("Unknown algebra strategy plugin: " + this.algebraStrategyPlugin);
        System.exit(-3);
        return null;
    }

    private VisualCodeInserterStrategy createVisualizerStrategy() {
        Set plugins = Plugins.getVisualizerStrategyPlugins();
        for (VisualCodeInserterStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.visualizerStrategyPlugin)) continue;
            return plugin.createVisualCodeInserterStrategy();
        }
        System.err.println("Unknown visualizer strategy plugin: " + this.algebraStrategyPlugin);
        System.exit(-4);
        return null;
    }

    private OptimizationStrategy createOptimizationStrategy() {
        Set plugins = Plugins.getOptimizationStrategyPlugins();
        for (OptimizationStrategyPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.optimizationStrategyPlugin)) continue;
            return plugin.createOptimizationStrategy();
        }
        System.err.println("Unknown optimization strategy plugin: " + this.optimizationStrategyPlugin);
        System.exit(-5);
        return null;
    }

    private CodeGenerator createCodeGenerator() {
        Set plugins = Plugins.getCodeGeneratorPlugins();
        for (CodeGeneratorPlugin plugin : plugins) {
            if (!plugin.getClass().getName().equals(this.codeGeneratorPlugin)) continue;
            return plugin.createCodeGenerator();
        }
        System.err.println("Unknown code generator plugin: " + this.codeGeneratorPlugin);
        System.exit(-6);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputFile getInputFile() throws Exception {
        String filename;
        InputStreamReader reader;
        if (this.inputFile.equals("-")) {
            reader = new InputStreamReader(System.in);
            filename = "stdin";
        } else {
            reader = new FileReader(this.inputFile);
            filename = this.inputFile;
        }
        try {
            String line;
            BufferedReader bufReader = new BufferedReader(reader);
            StringBuilder result = new StringBuilder();
            while ((line = bufReader.readLine()) != null) {
                result.append(line);
                result.append('\n');
            }
            InputFile inputFile = new InputFile(filename, result.toString());
            return inputFile;
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

