/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class Main {
    public static final String LIB_FOLDER = "plugins";
    public static final String MAIN_CLASS = "de.gaalop.gui.Main";

    public static void main(String[] args) {
        File libFolder = new File(LIB_FOLDER);
        URL[] urls = Main.getJarList(libFolder);
        URLClassLoader loader = new URLClassLoader(urls);
        try {
            Class<?> mainClass = Class.forName(MAIN_CLASS, false, loader);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            if (!Modifier.isStatic(mainMethod.getModifiers())) {
                System.err.println("Main method is not static in de.gaalop.gui.Main");
            } else {
                mainMethod.invoke(null, new Object[]{args});
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Unable to find de.gaalop.gui.Main");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            System.err.println("Unable to access main method in de.gaalop.gui.Main");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.err.println("Unable to find main method in de.gaalop.gui.Main");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.err.println("Main method does not accept String[] argument in de.gaalop.gui.Main");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("Main method needs to be public in de.gaalop.gui.Main");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("Main method threw an exception in de.gaalop.gui.Main");
            e.printStackTrace();
        }
    }

    private static URL[] getJarList(File libFolder) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!libFolder.isDirectory()) {
            throw new RuntimeException(libFolder.getAbsolutePath() + " is not a directory.");
        }
        for (File file : libFolder.listFiles()) {
            if (!Main.isJar(file)) continue;
            URL url = Main.getFileUrl(file);
            urls.add(url);
        }
        URL[] result = new URL[urls.size()];
        return urls.toArray(result);
    }

    private static URL getFileUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Filename cannot be converted to URL: " + file.getAbsolutePath(), e);
        }
    }

    private static boolean isJar(File file) {
        return file.getName().toLowerCase().endsWith(".jar");
    }
}

