/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.visualCodeInserter;

import de.gaalop.OptimizationException;
import de.gaalop.VisualCodeInserterStrategy;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.Variable;
import de.gaalop.visualCodeInserter.ExpressionStatementCollector;
import de.gaalop.visualCodeInserter.Plugin;
import java.util.HashMap;
import java.util.LinkedList;

public class VisualizerCodeInserter
implements VisualCodeInserterStrategy {
    private Plugin plugin;

    public VisualizerCodeInserter(Plugin plugin) {
        this.plugin = plugin;
    }

    public void transform(ControlFlowGraph graph) throws OptimizationException {
        LinkedList<ExpressionStatement> statements = ExpressionStatementCollector.collectAllStatements(graph);
        String prefix = "_V_";
        if (statements.size() > 0) {
            LinkedList<Variable> args = new LinkedList<Variable>();
            args.add(new Variable(prefix + "X"));
            args.add(new Variable(prefix + "Y"));
            args.add(new Variable(prefix + "Z"));
            graph.addInputVariable(new Variable(prefix + "X"));
            graph.addInputVariable(new Variable(prefix + "Y"));
            graph.addInputVariable(new Variable(prefix + "Z"));
            Variable visualizationPoint = new Variable(prefix + "POINT");
            graph.addLocalVariable(new Variable(prefix + "POINT"));
            AssignmentNode pointNode = new AssignmentNode(graph, visualizationPoint, (Expression)new MacroCall("createPoint", args));
            graph.getStartNode().insertAfter((SequentialNode)pointNode);
            HashMap renderingExpressions = graph.getRenderingExpressions();
            int i = 0;
            for (ExpressionStatement s : statements) {
                String productName = prefix + "PRODUCT" + i;
                AssignmentNode renderNode = new AssignmentNode(graph, new Variable(productName), (Expression)new InnerProduct(s.getExpression(), (Expression)visualizationPoint));
                graph.addLocalVariable(new Variable(productName));
                s.insertAfter((SequentialNode)renderNode);
                StoreResultNode outputRenderNode = new StoreResultNode(graph, new Variable(productName));
                graph.addLocalVariable(new Variable(productName));
                renderNode.insertAfter((SequentialNode)outputRenderNode);
                renderingExpressions.put(productName, s.getExpression());
                ++i;
            }
        }
    }
}

