/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.java;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import de.gaalop.java.OperatorPriority;

public class BladePrinter
implements ExpressionVisitor {
    private StringBuilder code = new StringBuilder();

    public String getCode() {
        return this.code.toString();
    }

    private void handleInfix(BinaryOperation operation, String operator, boolean withSpaces) {
        this.addChild((Expression)operation, operation.getLeft());
        if (withSpaces) {
            this.code.append(' ');
            this.code.append(operator);
            this.code.append(' ');
        } else {
            this.code.append(operator);
        }
        this.addChild((Expression)operation, operation.getRight());
    }

    private void addChild(Expression parent, Expression child) {
        if (OperatorPriority.hasLowerPriority(parent, child)) {
            this.code.append('(');
            child.accept((ExpressionVisitor)this);
            this.code.append(')');
        } else {
            child.accept((ExpressionVisitor)this);
        }
    }

    public void visit(Subtraction subtraction) {
        this.handleInfix((BinaryOperation)subtraction, "-", true);
    }

    public void visit(Addition addition) {
        this.handleInfix((BinaryOperation)addition, "+", true);
    }

    public void visit(Division division) {
        this.handleInfix((BinaryOperation)division, "/", true);
    }

    public void visit(InnerProduct innerProduct) {
        this.handleInfix((BinaryOperation)innerProduct, ".", true);
    }

    public void visit(Multiplication multiplication) {
        this.handleInfix((BinaryOperation)multiplication, "*", true);
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        this.code.append(mathFunctionCall.getFunction().toString());
        this.code.append('(');
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.code.append(')');
    }

    public void visit(Variable variable) {
        this.code.append(variable.getName());
    }

    public void visit(MultivectorComponent component) {
        this.code.append(component.getName());
        this.code.append('(');
        this.code.append(component.getBladeIndex() + 1);
        this.code.append(')');
    }

    public void visit(Exponentiation exponentiation) {
        this.code.append("Math.pow(");
        this.addChild((Expression)exponentiation, exponentiation.getLeft());
        this.code.append(',');
        this.addChild((Expression)exponentiation, exponentiation.getRight());
        this.code.append(")");
    }

    public void visit(FloatConstant floatConstant) {
        this.code.append(Double.toString(floatConstant.getValue()));
    }

    public void visit(OuterProduct outerProduct) {
        this.handleInfix((BinaryOperation)outerProduct, "^", false);
    }

    public void visit(BaseVector baseVector) {
        this.code.append(baseVector.toString());
    }

    public void visit(Negation negation) {
        this.code.append('-');
        this.addChild((Expression)negation, negation.getOperand());
    }

    public void visit(Reverse node) {
        this.code.append('~');
        this.addChild((Expression)node, node.getOperand());
    }

    public void visit(LogicalOr node) {
        this.handleInfix((BinaryOperation)node, "||", true);
    }

    public void visit(LogicalAnd node) {
        this.handleInfix((BinaryOperation)node, "&&", true);
    }

    public void visit(LogicalNegation node) {
        this.code.append('!');
        this.addChild((Expression)node, node.getOperand());
    }

    public void visit(Equality node) {
        this.handleInfix((BinaryOperation)node, "==", true);
    }

    public void visit(Inequality node) {
        this.handleInfix((BinaryOperation)node, "!=", true);
    }

    public void visit(Relation relation) {
        this.handleInfix((BinaryOperation)relation, relation.getTypeString(), false);
    }

    public void visit(FunctionArgument node) {
        throw new IllegalStateException("Macros should have been inlined and are not allowed for output.");
    }

    public void visit(MacroCall node) {
        throw new IllegalStateException("Macros should have been inlined and are not allowed for output.");
    }
}

