/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gappDebugger;

import de.gaalop.algebra.BladeArrayRoutines;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EmptyControlFlowVisitor;
import de.gaalop.gapp.executer.Executer;
import de.gaalop.gapp.executer.MultivectorWithValues;
import de.gaalop.gapp.instructionSet.GAPPAssignInputsVector;
import de.gaalop.gapp.instructionSet.GAPPAssignMv;
import de.gaalop.gapp.instructionSet.GAPPBaseInstruction;
import de.gaalop.gapp.instructionSet.GAPPCalculateMv;
import de.gaalop.gapp.instructionSet.GAPPDotVectors;
import de.gaalop.gapp.instructionSet.GAPPResetMv;
import de.gaalop.gapp.instructionSet.GAPPSetMv;
import de.gaalop.gapp.instructionSet.GAPPSetVector;
import de.gaalop.gapp.variables.GAPPMultivector;
import de.gaalop.gapp.visitor.GAPPVisitor;
import de.gaalop.gapp.visitor.InstructionType;
import de.gaalop.gappDebugger.UI;
import de.gaalop.tba.Algebra;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class Controller {
    private UI ui;
    private HashMap<String, Double> inputValues = new HashMap();
    private DefaultListModel modelVars = new DefaultListModel();
    private DefaultListModel modelSrc = new DefaultListModel();
    private Algebra algebra;
    private GAPPBaseInstruction[] instructions;
    private int curInstruction = 0;
    private Executer executer;
    private LinkedList<GAPPBaseInstruction> instructionsLoc;

    public Controller(UI ui1) {
        this.ui = ui1;
        this.ui.jListVariables.setModel(this.modelVars);
        this.ui.jListSrc.setModel(this.modelSrc);
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Controller.this.refreshValueTable();
            }
        };
        this.ui.jListVariables.addListSelectionListener(listener);
    }

    private void refreshValueTable() {
        String name = (String)this.ui.jListVariables.getSelectedValue();
        if (name != null && !name.contains("=")) {
            String varName = name.split("=")[0].trim();
            DefaultTableModel model = (DefaultTableModel)this.ui.jTable1.getModel();
            while (model.getRowCount() > 0) {
                model.removeRow(0);
            }
            MultivectorWithValues v = (MultivectorWithValues)this.executer.getValues().get(varName);
            if (v.isMultivector()) {
                int bladeCount = v.getEntries().length;
                for (int blade = 0; blade < bladeCount; ++blade) {
                    Vector<Object> row = new Vector<Object>();
                    row.add(blade);
                    row.add(this.algebra.getBlade(blade).toString());
                    row.add(Double.toString(v.getEntry(blade)));
                    model.addRow(row);
                }
            } else {
                int entryCount = v.getEntries().length;
                for (int entry = 0; entry < entryCount; ++entry) {
                    Vector<Object> row = new Vector<Object>();
                    row.add(entry);
                    row.add("");
                    row.add(Double.toString(v.getEntry(entry)));
                    model.addRow(row);
                }
            }
            model.fireTableDataChanged();
            this.ui.jTable1.repaint();
        }
    }

    public void restart() {
        this.executer = new Executer(this.inputValues);
        this.curInstruction = 0;
        this.repaint();
    }

    private void evaluateInstruction() {
        this.instructions[this.curInstruction].accept((GAPPVisitor)this.executer, null);
    }

    public boolean nextInstruction() {
        if (this.curInstruction < this.instructions.length) {
            this.evaluateInstruction();
            this.repaint();
        }
        if (this.curInstruction < this.instructions.length) {
            ++this.curInstruction;
            this.repaint();
        }
        return this.curInstruction < this.instructions.length;
    }

    public void run() {
        if (this.curInstruction < this.instructions.length) {
            while (this.nextInstruction()) {
            }
        }
    }

    public void setVariableValue() {
        String input = JOptionPane.showInputDialog("Please type in the assignment of a scalar variable!\nMany assignments can be set using ; as separator.");
        this.setVariableValue(input);
    }

    public void setVariableValue(String input) {
        if (input != null) {
            boolean changed = false;
            for (String part : input.split(";")) {
                if (!part.contains("=")) continue;
                String[] parts = part.split("=");
                String varname = parts[0].trim();
                Double value = Double.parseDouble(parts[1].trim());
                this.inputValues.put(varname, value);
                changed = true;
            }
            if (changed) {
                this.restart();
            }
        }
    }

    public GAPPBaseInstruction createBaseInstruction(String cmd) {
        InstructionType instr = InstructionType.valueOf((String)cmd);
        switch (instr) {
            case assignMv: {
                return new GAPPAssignMv(null);
            }
            case assignInputsVector: {
                return new GAPPAssignInputsVector(null);
            }
            case calculateMv: {
                return new GAPPCalculateMv(null, null, null, null);
            }
            case dotVectors: {
                GAPPMultivector m = null;
                return new GAPPDotVectors(m, null, null);
            }
            case resetMv: {
                return new GAPPResetMv(null, 0);
            }
            case setMv: {
                return new GAPPSetMv(null, null, null, null);
            }
            case setVector: {
                return new GAPPSetVector(null, null);
            }
        }
        return null;
    }

    public void setAlgebraBlades(String[] base) {
        for (int i = 0; i < base.length; ++i) {
            base[i] = base[i].trim();
        }
        this.algebra = new Algebra(base, BladeArrayRoutines.createBlades((String[])base));
    }

    public void loadSource(ControlFlowGraph graph) {
        this.instructionsLoc = new LinkedList();
        EmptyControlFlowVisitor visitor = new EmptyControlFlowVisitor(){

            public void visit(AssignmentNode node) {
                Controller.this.instructionsLoc.addAll(node.getGAPP().getInstructions());
                super.visit(node);
            }
        };
        graph.accept((ControlFlowVisitor)visitor);
        this.instructions = this.instructionsLoc.toArray(new GAPPBaseInstruction[0]);
        this.modelSrc.clear();
        for (GAPPBaseInstruction instruction : this.instructionsLoc) {
            this.modelSrc.addElement(instruction.toString());
        }
        this.ui.jListSrc.repaint();
    }

    public void repaint() {
        this.modelVars.clear();
        Object[] keyArr = this.inputValues.keySet().toArray(new String[0]);
        Arrays.sort(keyArr);
        for (Object var : keyArr) {
            this.modelVars.addElement((String)var + " = " + this.inputValues.get(var).toString());
        }
        Object[] keyArr2 = this.executer.getValues().keySet().toArray(new String[0]);
        Arrays.sort(keyArr2);
        for (Object var : keyArr2) {
            this.modelVars.addElement(var);
        }
        this.ui.jListSrc.repaint();
        this.ui.jListVariables.repaint();
        if (this.curInstruction < this.instructions.length) {
            this.ui.jListSrc.setSelectedIndex(this.curInstruction);
        } else {
            this.ui.jListSrc.clearSelection();
        }
    }
}

