/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dot;

import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dot.DfgVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class CfgVisitor
implements ControlFlowVisitor {
    private StringBuilder result = new StringBuilder();
    private Map<Object, String> idMap = new HashMap<Object, String>();
    private Stack<LoopNode> nestedLoops = new Stack();
    private int highestId = 0;
    private static final String EDGE_COLOR_FORWARD = "darkolivegreen1";
    private static final String EDGE_COLOR_BACKWARDS = "darkorange1";

    public String getResult() {
        return this.result.toString();
    }

    private String getId(Object obj) {
        if (!this.idMap.containsKey(obj)) {
            ++this.highestId;
            this.idMap.put(obj, "node" + this.highestId);
        }
        return this.idMap.get(obj);
    }

    private void addForwardEdge(Object n1, Object n2) {
        this.addEdge(n1, n2, EDGE_COLOR_FORWARD);
    }

    private void addBackwardsEdge(Object n1, Object n2) {
        this.addEdge(n1, n2, EDGE_COLOR_BACKWARDS);
    }

    private void addEdge(Object n1, Object n2, String color) {
        if (n2 instanceof BlockEndNode) {
            return;
        }
        this.result.append('\t');
        this.result.append(this.getId(n1));
        this.result.append(" -> ");
        this.result.append(this.getId(n2));
        this.result.append(" [color=\"").append(color).append("\"]");
        this.result.append(";\n");
    }

    private void addNode(Node node, String label) {
        this.result.append("\t");
        this.result.append(this.getId(node));
        this.result.append(" [label=\"");
        this.result.append(label);
        this.result.append("\"];\n");
        this.addPredecessorEdges(node);
    }

    private void addPredecessorEdges(Node node) {
        for (Node predecessor : node.getPredecessors()) {
            this.addBackwardsEdge(node, predecessor);
        }
    }

    public void visit(StartNode startNode) {
        this.result.append("digraph {\n");
        this.addNode((Node)startNode, "Start");
        this.addForwardEdge(startNode, startNode.getSuccessor());
        startNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(AssignmentNode assignmentNode) {
        this.addNode((Node)assignmentNode, "Assignment:\\n" + assignmentNode.getVariable());
        this.addForwardEdge(assignmentNode, assignmentNode.getSuccessor());
        String subnodePrefix = this.getId(assignmentNode) + "_";
        String stmtList = this.getCode(assignmentNode.getValue(), subnodePrefix);
        this.result.append(stmtList);
        this.result.append("\t");
        this.result.append(subnodePrefix);
        this.result.append("1 -> ");
        this.result.append(this.getId(assignmentNode));
        this.result.append(";\n");
        assignmentNode.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(ExpressionStatement node) {
        this.addNode((Node)node, "Expression:\\n" + node.getExpression());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(StoreResultNode node) {
        this.addNode((Node)node, "Output:\\n" + node.getValue());
        this.addForwardEdge(node, node.getSuccessor());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(IfThenElseNode node) {
        String label = "if\\n" + node.getCondition().toString();
        this.addNode((Node)node, label);
        this.addForwardEdge(node, node.getPositive());
        node.getPositive().accept((ControlFlowVisitor)this);
        if (!(node.getNegative() instanceof BlockEndNode)) {
            this.addForwardEdge(node, node.getNegative());
            node.getNegative().accept((ControlFlowVisitor)this);
        }
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(LoopNode node) {
        this.addNode((Node)node, "loop");
        this.addForwardEdge(node, node.getBody());
        this.nestedLoops.push(node);
        node.getBody().accept((ControlFlowVisitor)this);
        this.nestedLoops.pop();
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BreakNode node) {
        this.addNode((Node)node, "break");
        this.addForwardEdge(node, this.nestedLoops.peek().getSuccessor());
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    public void visit(BlockEndNode node) {
        SequentialNode base = node.getBase();
        if (base instanceof LoopNode) {
            for (Node p : node.getPredecessors()) {
                if (!this.idMap.containsKey(p)) continue;
                this.addForwardEdge(p, base);
            }
        } else {
            this.addForwardEdge(base, base.getSuccessor());
        }
    }

    public void visit(EndNode endNode) {
        this.addNode((Node)endNode, "End");
        this.result.append("}\n");
    }

    private String getCode(Expression expression, String prefix) {
        DfgVisitor visitor = new DfgVisitor();
        visitor.setIdPrefix(prefix);
        expression.accept((ExpressionVisitor)visitor);
        return visitor.toString();
    }

    public void visit(Macro node) {
        throw new IllegalArgumentException("Macros should have been inlined.");
    }

    public void visit(ColorNode node) {
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

