/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dot;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.UnaryOperation;
import de.gaalop.dfg.Variable;
import java.util.IdentityHashMap;
import java.util.Map;

public class DfgVisitor
implements ExpressionVisitor {
    private String idPrefix = "node";
    private StringBuilder result = new StringBuilder();
    private Map<Object, String> idMap = new IdentityHashMap<Object, String>();
    private int highestId = 0;

    public String toString() {
        return this.result.toString();
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    private String getId(Object obj) {
        if (!this.idMap.containsKey(obj)) {
            ++this.highestId;
            this.idMap.put(obj, this.idPrefix + this.highestId);
        }
        return this.idMap.get(obj);
    }

    private void addEdge(Object n1, Object n2) {
        this.result.append('\t');
        this.result.append(this.getId(n1));
        this.result.append(" -> ");
        this.result.append(this.getId(n2));
        this.result.append(";\n");
    }

    private void addNode(Object node, String label) {
        this.result.append("\t");
        this.result.append(this.getId(node));
        this.result.append(" [label=\"");
        this.result.append(label);
        this.result.append("\", shape=\"box\"];\n");
    }

    private void addBinaryOp(BinaryOperation op, String label) {
        this.addNode(op, label);
        op.getLeft().accept((ExpressionVisitor)this);
        op.getRight().accept((ExpressionVisitor)this);
        this.addEdge(op.getLeft(), op);
        this.addEdge(op.getRight(), op);
    }

    public void visit(Subtraction subtraction) {
        this.addBinaryOp((BinaryOperation)subtraction, "-");
    }

    public void visit(Addition addition) {
        this.addBinaryOp((BinaryOperation)addition, "+");
    }

    public void visit(Division division) {
        this.addBinaryOp((BinaryOperation)division, "/");
    }

    public void visit(InnerProduct innerProduct) {
        this.addBinaryOp((BinaryOperation)innerProduct, ".");
    }

    public void visit(Multiplication multiplication) {
        this.addBinaryOp((BinaryOperation)multiplication, "*");
    }

    public void visit(MathFunctionCall mathFunctionCall) {
        this.addNode(mathFunctionCall, mathFunctionCall.getFunction().toString());
        mathFunctionCall.getOperand().accept((ExpressionVisitor)this);
        this.addEdge(mathFunctionCall.getOperand(), mathFunctionCall);
    }

    public void visit(BaseVector baseVector) {
        this.addNode(baseVector, baseVector.toString());
    }

    public void visit(Negation negation) {
        this.addUnaryOp((UnaryOperation)negation, "-");
    }

    public void visit(Reverse node) {
        this.addUnaryOp((UnaryOperation)node, "~");
    }

    private void addUnaryOp(UnaryOperation node, String operator) {
        this.addNode(node, operator);
        node.getOperand().accept((ExpressionVisitor)this);
        this.addEdge(node.getOperand(), node);
    }

    public void visit(Variable variable) {
        this.addNode(variable, variable.toString());
    }

    public void visit(MultivectorComponent component) {
        this.addNode(component, component.toString());
    }

    public void visit(Exponentiation exponentiation) {
        this.addBinaryOp((BinaryOperation)exponentiation, "^");
    }

    public void visit(FloatConstant floatConstant) {
        this.addNode(floatConstant, floatConstant.toString());
    }

    public void visit(OuterProduct outerProduct) {
        this.addBinaryOp((BinaryOperation)outerProduct, "^");
    }

    public void visit(LogicalOr node) {
        this.addBinaryOp((BinaryOperation)node, "||");
    }

    public void visit(LogicalAnd node) {
        this.addBinaryOp((BinaryOperation)node, "&&");
    }

    public void visit(LogicalNegation node) {
        this.addUnaryOp((UnaryOperation)node, "!");
    }

    public void visit(Equality node) {
        this.addBinaryOp((BinaryOperation)node, "==");
    }

    public void visit(Inequality node) {
        this.addBinaryOp((BinaryOperation)node, "!=");
    }

    public void visit(Relation relation) {
        this.addBinaryOp((BinaryOperation)relation, relation.getTypeString());
    }

    public void visit(FunctionArgument node) {
        throw new IllegalArgumentException("Macros should have been inlined.");
    }

    public void visit(MacroCall node) {
        throw new IllegalArgumentException("Macros should have been inlined.");
    }
}

