/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.dot;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorException;
import de.gaalop.OutputFile;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.dot.CfgVisitor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public enum DotCodeGenerator implements CodeGenerator
{
    INSTANCE;


    public Set<OutputFile> generate(ControlFlowGraph in) throws CodeGeneratorException {
        String dotCode = this.generateCode(in);
        String filename = this.generateFilename(in);
        Charset charset = Charset.forName("UTF-8");
        OutputFile output = new OutputFile(filename, dotCode, charset);
        return Collections.singleton(output);
    }

    private String generateFilename(ControlFlowGraph in) {
        String filename = "gaalop.dot";
        if (in.getSource() != null) {
            filename = in.getSource().getName();
            int lastDotIndex = filename.lastIndexOf(46);
            if (lastDotIndex != -1) {
                filename = filename.substring(0, lastDotIndex);
            }
            filename = filename + ".dot";
        }
        return filename;
    }

    private String generateCode(ControlFlowGraph in) {
        CfgVisitor visitor = new CfgVisitor();
        in.accept((ControlFlowVisitor)visitor);
        return visitor.getResult();
    }
}

