/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet;

import de.gaalop.dfg.Expression;
import de.gaalop.gaalet.ExpressionCreator;
import de.gaalop.gaalet.GaaletBladeTable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class GaaletMultiVector {
    public LinkedHashMap<Integer, Expression> gaalopBlades;
    String name;

    public GaaletMultiVector(String name) {
        this.name = name;
        this.gaalopBlades = new LinkedHashMap();
    }

    public String getDefinition() {
        Map<Integer, Expression> list = this.getSortedGaaletBlades();
        String result = " ";
        Set<Integer> Gaalet = list.keySet();
        Iterator<Integer> it = Gaalet.iterator();
        while (it.hasNext()) {
            int val = it.next();
            result = val < 16 ? result + "0x0" : result + "0x";
            result = result + Integer.toHexString(val);
            if (!it.hasNext()) continue;
            result = result + ", ";
        }
        return result;
    }

    public Map<Integer, Expression> getGaalopBlades() {
        return this.gaalopBlades;
    }

    public int getBladePosInArray(int gaalopBlade) {
        int GaaletBlade = GaaletBladeTable.gaalopToGaalet(gaalopBlade);
        int index = 0;
        for (Map.Entry<Integer, Expression> newBlade : this.getSortedGaaletBlades().entrySet()) {
            if (newBlade.getKey() == GaaletBlade) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void addComponent(int GaalopBlade) {
        this.gaalopBlades.put(new Integer(GaalopBlade), null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GaaletMultiVector) {
            return this.name.equals(((GaaletMultiVector)obj).getName());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    private Map<Integer, Expression> getSortedGaaletBlades() {
        Map<Integer, Expression> GaaletList = this.getUnsortedGaaletBlades();
        LinkedList<Map.Entry<Integer, Expression>> list = new LinkedList<Map.Entry<Integer, Expression>>(GaaletList.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, Expression>>(){

            @Override
            public int compare(Map.Entry<Integer, Expression> o1, Map.Entry<Integer, Expression> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        LinkedHashMap<Integer, Expression> sorted = new LinkedHashMap<Integer, Expression>();
        for (Map.Entry entry : list) {
            sorted.put((Integer)entry.getKey(), (Expression)entry.getValue());
        }
        return sorted;
    }

    public void addGaaletBlades(String blade) {
        int gaalop = GaaletBladeTable.numberToBlade(blade);
        this.addComponent(gaalop);
    }

    private Map<Integer, Expression> getUnsortedGaaletBlades() {
        LinkedHashMap<Integer, Expression> GaaletList = new LinkedHashMap<Integer, Expression>();
        for (Map.Entry<Integer, Expression> newBlade : this.gaalopBlades.entrySet()) {
            GaaletList.put(GaaletBladeTable.gaalopToGaalet(newBlade.getKey()), newBlade.getValue());
        }
        return GaaletList;
    }

    public int get(int index) {
        Set<Integer> list = this.gaalopBlades.keySet();
        return (Integer)list.toArray()[index];
    }

    public void addGaaletTupel(Integer GaaletBlade, Expression value) {
        this.gaalopBlades.put(GaaletBlade, value);
    }

    public Expression getExpression() {
        ExpressionCreator expCr = new ExpressionCreator();
        return expCr.createExpression(this);
    }

    public GaaletBladeTable getTable() {
        return new GaaletBladeTable();
    }
}

