/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet.output;

import de.gaalop.NameTable;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.FindStoreOutputNodes;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.Variable;
import de.gaalop.gaalet.GaaletMultiVector;
import de.gaalop.gaalet.output.FieldsUsedVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CppVisitor
extends de.gaalop.cpp.CppVisitor {
    private boolean ifPossible = true;
    protected Map<StoreResultNode, String> outputNamesMap = new HashMap<StoreResultNode, String>();
    protected Set<GaaletMultiVector> vectorSet = new HashSet<GaaletMultiVector>();

    public CppVisitor(boolean standalone) {
        super(standalone);
    }

    public CppVisitor(String variableType) {
        super(false);
        this.variableType = variableType;
    }

    protected void printVarName(String key) {
        this.code.append(NameTable.getInstance().get(key));
    }

    public void visit(StartNode node) {
        List inputParameters;
        this.graph = node.getGraph();
        FindStoreOutputNodes findOutput = new FindStoreOutputNodes();
        this.graph.accept((ControlFlowVisitor)findOutput);
        for (StoreResultNode var : findOutput.getNodes()) {
            String outputName = var.getValue().getName() + "_opt";
            this.outputNamesMap.put(var, outputName);
        }
        if (this.standalone) {
            this.code.append("void calculate(");
            inputParameters = this.sortVariables(this.graph.getInputVariables());
            for (Variable var : inputParameters) {
                this.code.append(this.variableType).append(" ");
                this.printVarName(var.getName());
                this.code.append(", ");
            }
            for (Variable var : findOutput.getNodes()) {
                this.code.append(this.variableType).append(" **");
                this.printVarName(this.outputNamesMap.get(var));
                this.code.append(", ");
            }
            if (!this.graph.getInputVariables().isEmpty() || !findOutput.getNodes().isEmpty()) {
                this.code.setLength(this.code.length() - 2);
            }
            this.code.append(") {\n");
            ++this.indentation;
        }
        if (this.ifPossible && !this.standalone) {
            FieldsUsedVisitor fieldVisitor;
            inputParameters = this.sortVariables(this.graph.getInputVariables());
            for (Variable var : inputParameters) {
                fieldVisitor = new FieldsUsedVisitor(var.getName());
                this.graph.accept((ControlFlowVisitor)fieldVisitor);
                this.code.append("// This is input: ");
                this.code.append(fieldVisitor.giveDefinition(this.variableType));
                this.code.append("\n");
            }
            this.code.append("\n");
            for (Variable var : findOutput.getNodes()) {
                fieldVisitor = new FieldsUsedVisitor(var.getValue().getName());
                this.graph.accept((ControlFlowVisitor)fieldVisitor);
                this.code.append("// This is output: ");
                this.code.append(fieldVisitor.giveDefinition());
                this.code.append("\n");
            }
        }
        this.handleLocalVariables();
        this.createVectorSet(findOutput);
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }

    protected void createVectorSet(FindStoreOutputNodes findOutput) {
        FieldsUsedVisitor fieldVisitor;
        for (Variable var : this.graph.getInputVariables()) {
            fieldVisitor = new FieldsUsedVisitor(var.getName());
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.vectorSet.add(fieldVisitor.getMultiVector());
        }
        for (Variable var : this.graph.getLocalVariables()) {
            fieldVisitor = new FieldsUsedVisitor(var.getName());
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.vectorSet.add(fieldVisitor.getMultiVector());
        }
        for (Variable var : findOutput.getNodes()) {
            fieldVisitor = new FieldsUsedVisitor(var.getValue().getName());
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.vectorSet.add(fieldVisitor.getMultiVector());
        }
    }

    protected void handleLocalVariables() {
        HashSet<String> varNames = new HashSet<String>();
        for (Variable variable : this.graph.getLocalVariables()) {
            varNames.add(variable.getName());
        }
        for (String string : varNames) {
            this.appendIndentation();
            FieldsUsedVisitor fieldVisitor = new FieldsUsedVisitor(string);
            this.graph.accept((ControlFlowVisitor)fieldVisitor);
            this.code.append(fieldVisitor.giveDefinition(this.variableType));
            this.code.append("\n");
        }
        if (!this.graph.getLocalVariables().isEmpty()) {
            this.code.append("\n");
        }
    }

    public void visit(AssignmentNode node) {
        if (this.assigned.contains(node.getVariable().getName())) {
            this.log.warn((Object)("Reuse of variable " + node.getVariable().getName() + ". Make sure to reset this variable or use another name."));
            this.code.append("\n");
            this.appendIndentation();
            this.code.append("// Warning: reuse of variable ");
            this.code.append(node.getVariable().getName());
            this.code.append(".\n");
            this.appendIndentation();
            this.code.append("// Make sure to reset this variable or use another name.\n");
            this.assigned.remove(node.getVariable().getName());
        }
        this.appendIndentation();
        node.getVariable().accept((ExpressionVisitor)this);
        this.code.append(" = ");
        node.getValue().accept((ExpressionVisitor)this);
        this.code.append(";\n");
        node.getSuccessor().accept((ControlFlowVisitor)this);
    }
}

