/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.gaalet.output;

import de.gaalop.CodeGenerator;
import de.gaalop.CodeGeneratorPlugin;
import de.gaalop.ConfigurationProperty;
import de.gaalop.NameTable;
import de.gaalop.gaalet.output.CppCodeGenerator;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Plugin
implements CodeGeneratorPlugin {
    private Log log = LogFactory.getLog(Plugin.class);
    private Image icon;
    private String variableType = "double";
    @ConfigurationProperty(type=ConfigurationProperty.Type.BOOLEAN)
    public boolean useNameTable;

    public String getVariableType() {
        return this.variableType;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public boolean isUseNameTable() {
        this.useNameTable = NameTable.isInUse();
        return this.useNameTable;
    }

    public void setUseNameTable(boolean useNameTable) {
        NameTable.setUse((boolean)useNameTable);
        this.useNameTable = useNameTable;
    }

    public Plugin() {
        URL url = this.getClass().getResource("/de/gaalop/gaalet/icon.png");
        if (url != null) {
            try {
                this.icon = ImageIO.read(url);
            }
            catch (IOException e) {
                this.log.error((Object)("Unable to read plugin icon " + url));
            }
        } else {
            this.log.warn((Object)"Unable to find plugin icon!");
        }
        this.useNameTable = false;
    }

    public CodeGenerator createCodeGenerator() {
        return new CppCodeGenerator(this);
    }

    public String getName() {
        return "C/C++ (gaalet)";
    }

    public String getDescription() {
        return "This plugin generates C/C++ code putting the output data in a gaalet mulivector.";
    }

    public Image getIcon() {
        return this.icon;
    }
}

