/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop;

import de.gaalop.dfg.Addition;
import de.gaalop.dfg.BaseVector;
import de.gaalop.dfg.BinaryOperation;
import de.gaalop.dfg.Division;
import de.gaalop.dfg.Equality;
import de.gaalop.dfg.Exponentiation;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.ExpressionVisitor;
import de.gaalop.dfg.FloatConstant;
import de.gaalop.dfg.FunctionArgument;
import de.gaalop.dfg.Inequality;
import de.gaalop.dfg.InnerProduct;
import de.gaalop.dfg.LogicalAnd;
import de.gaalop.dfg.LogicalNegation;
import de.gaalop.dfg.LogicalOr;
import de.gaalop.dfg.MacroCall;
import de.gaalop.dfg.MathFunctionCall;
import de.gaalop.dfg.Multiplication;
import de.gaalop.dfg.MultivectorComponent;
import de.gaalop.dfg.Negation;
import de.gaalop.dfg.OuterProduct;
import de.gaalop.dfg.Relation;
import de.gaalop.dfg.Reverse;
import de.gaalop.dfg.Subtraction;
import de.gaalop.dfg.Variable;
import java.util.HashSet;
import java.util.Set;

public class UsedVariablesVisitor
implements ExpressionVisitor {
    private Set<Variable> variables = new HashSet<Variable>();

    public Set<Variable> getVariables() {
        return this.variables;
    }

    private void visitBinaryOperation(BinaryOperation op) {
        op.getLeft().accept(this);
        op.getRight().accept(this);
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryOperation(subtraction);
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryOperation(addition);
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryOperation(division);
    }

    @Override
    public void visit(InnerProduct innerProduct) {
        this.visitBinaryOperation(innerProduct);
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryOperation(multiplication);
    }

    @Override
    public void visit(MathFunctionCall mathFunctionCall) {
        mathFunctionCall.getOperand().accept(this);
    }

    @Override
    public void visit(Variable variable) {
        this.variables.add(variable);
    }

    @Override
    public void visit(MultivectorComponent component) {
        this.variables.add(component);
    }

    @Override
    public void visit(Exponentiation exponentiation) {
        this.visitBinaryOperation(exponentiation);
    }

    @Override
    public void visit(FloatConstant floatConstant) {
    }

    @Override
    public void visit(OuterProduct outerProduct) {
        this.visitBinaryOperation(outerProduct);
    }

    @Override
    public void visit(BaseVector baseVector) {
    }

    @Override
    public void visit(Negation negation) {
        negation.getOperand().accept(this);
    }

    @Override
    public void visit(Reverse node) {
        node.getOperand().accept(this);
    }

    @Override
    public void visit(LogicalOr node) {
        this.visitBinaryOperation(node);
    }

    @Override
    public void visit(LogicalAnd node) {
        this.visitBinaryOperation(node);
    }

    @Override
    public void visit(LogicalNegation node) {
        node.getOperand().accept(this);
    }

    @Override
    public void visit(Equality node) {
        this.visitBinaryOperation(node);
    }

    @Override
    public void visit(Inequality node) {
        this.visitBinaryOperation(node);
    }

    @Override
    public void visit(Relation relation) {
        this.visitBinaryOperation(relation);
    }

    @Override
    public void visit(FunctionArgument node) {
    }

    @Override
    public void visit(MacroCall node) {
        for (Expression arg : node.getArguments()) {
            arg.accept(this);
        }
    }
}

