/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.InputFile;
import de.gaalop.cfg.AlgebraDefinitionFile;
import de.gaalop.cfg.AssignmentNode;
import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.BreakNode;
import de.gaalop.cfg.ColorNode;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.ExpressionStatement;
import de.gaalop.cfg.GlobalSettings;
import de.gaalop.cfg.IfThenElseNode;
import de.gaalop.cfg.LoopNode;
import de.gaalop.cfg.Macro;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.cfg.Slider;
import de.gaalop.cfg.StartNode;
import de.gaalop.cfg.StoreResultNode;
import de.gaalop.cfg.UnknownMacroCall;
import de.gaalop.dfg.Expression;
import de.gaalop.dfg.Variable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ControlFlowGraph {
    private Log log = LogFactory.getLog(ControlFlowGraph.class);
    private Set<Variable> localVariables = new HashSet<Variable>();
    private Set<Variable> scalarVariables = new HashSet<Variable>();
    private Set<Variable> inputVariables = new HashSet<Variable>();
    private AlgebraDefinitionFile algebraDefinitionFile = new AlgebraDefinitionFile();
    private final StartNode startNode;
    private final EndNode endNode;
    private InputFile source;
    private Map<String, Macro> macros = new HashMap<String, Macro>();
    private Set<Slider> sliders = new HashSet<Slider>();
    private ColorNode bgColor;
    private Set<String> pragmaOutputVariables = new HashSet<String>();
    private Set<String> pragmaOnlyEvaluateVariables = new HashSet<String>();
    private HashMap<String, String> pragmaMinValue = new HashMap();
    private HashMap<String, String> pragmaMaxValue = new HashMap();
    public LinkedList<ExpressionStatement> visualizerExpressions = new LinkedList();
    private HashMap<String, Expression> renderingExpressions = new HashMap();
    public GlobalSettings globalSettings = new GlobalSettings();
    public LinkedList<UnknownMacroCall> unknownMacros = new LinkedList();
    public String algebraName;
    public boolean asRessource;
    public String algebraBaseDirectory;

    public HashMap<String, Expression> getRenderingExpressions() {
        return this.renderingExpressions;
    }

    public void setRenderingExpressions(HashMap<String, Expression> renderingExpressions) {
        this.renderingExpressions = renderingExpressions;
    }

    public HashMap<String, String> getPragmaMaxValue() {
        return this.pragmaMaxValue;
    }

    public HashMap<String, String> getPragmaMinValue() {
        return this.pragmaMinValue;
    }

    public Set<String> getPragmaOutputVariables() {
        return this.pragmaOutputVariables;
    }

    public Set<String> getPragmaOnlyEvaluateVariables() {
        return this.pragmaOnlyEvaluateVariables;
    }

    public void addPragmaOutputVariable(String name) {
        this.pragmaOutputVariables.add(name);
    }

    public void addPragmaOnlyEvaluateVariable(String name) {
        this.pragmaOnlyEvaluateVariables.add(name);
    }

    public void addScalarVariable(Variable tempVariable) {
        this.scalarVariables.add(tempVariable);
    }

    public void removeScalarVariable(String name) {
        this.scalarVariables.remove(new Variable(name));
    }

    public Set<Variable> getScalarVariables() {
        return this.scalarVariables;
    }

    public void addPragmaMinMaxValues(String variable, String min, String max) {
        this.pragmaMaxValue.put(variable, max);
        this.pragmaMinValue.put(variable, min);
    }

    public void addMacro(Macro macro) {
        this.macros.put(macro.getName(), macro);
    }

    public void addSlider(Slider slider) {
        this.sliders.add(slider);
    }

    public Set<Slider> getSliders() {
        return this.sliders;
    }

    public void setBGColor(ColorNode color) {
        this.bgColor = color;
    }

    public ColorNode getBGColor() {
        return this.bgColor;
    }

    public Macro getMacro(String name) {
        return this.macros.get(name);
    }

    public Set<Macro> getMacros() {
        return new HashSet<Macro>(this.macros.values());
    }

    public ControlFlowGraph() {
        this.startNode = new StartNode(this);
        this.endNode = new EndNode(this);
        this.startNode.setSuccessor(this.endNode);
        this.endNode.addPredecessor(this.startNode);
    }

    public EndNode getEndNode() {
        return this.endNode;
    }

    public StartNode getStartNode() {
        return this.startNode;
    }

    public InputFile getSource() {
        return this.source;
    }

    public void setSource(InputFile source) {
        this.source = source;
    }

    public Set<Variable> getLocalVariables() {
        return Collections.unmodifiableSet(this.localVariables);
    }

    public Set<Variable> getLocalVariablesModifiable() {
        return this.localVariables;
    }

    public Set<Variable> getInputVariables() {
        return Collections.unmodifiableSet(this.inputVariables);
    }

    public void addLocalVariable(Variable variable) {
        if (this.inputVariables.contains(variable)) {
            throw new IllegalArgumentException("The Variable " + variable.getName() + " cannot be a local variable and an input variable at the same time.");
        }
        this.localVariables.add(variable);
    }

    public void removeLocalVariable(Variable variable) {
        this.localVariables.remove(variable);
    }

    public boolean containsLocalVariable(String name) {
        for (Variable v : this.localVariables) {
            if (!v.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addInputVariable(Variable variable) {
        String name = variable.getName();
        if ("true".equals(name) || "false".equals(name)) {
            return;
        }
        if (this.localVariables.contains(variable)) {
            throw new IllegalArgumentException("The Variable " + name + " cannot be a local variable and an input variable at the same time.");
        }
        this.inputVariables.add(variable);
    }

    public void removeInputVariable(Variable variable) {
        this.inputVariables.remove(variable);
    }

    public void accept(ControlFlowVisitor visitor) {
        this.startNode.accept(visitor);
    }

    public void removeNode(SequentialNode node) {
        Node successor = node.getSuccessor();
        successor.removePredecessor(node);
        HashSet<Node> predecessors = new HashSet<Node>(node.getPredecessors());
        for (Node predecessor : predecessors) {
            successor.addPredecessor(predecessor);
            predecessor.replaceSuccessor(node, successor);
        }
    }

    public String toString() {
        SequentialNode curr = this.startNode;
        StringBuilder sb = new StringBuilder();
        sb.append("CFG:\n");
        sb.append(this.startNode);
        while (true) {
            sb.append("\n--> ");
            if (!(curr.getSuccessor() instanceof SequentialNode)) break;
            curr = (SequentialNode)curr.getSuccessor();
            sb.append(curr);
        }
        Node end = curr.getSuccessor();
        sb.append(end);
        return sb.toString();
    }

    public String prettyPrint() {
        Printer printer = new Printer();
        this.accept(printer);
        return printer.getCode();
    }

    public AlgebraDefinitionFile getAlgebraDefinitionFile() {
        return this.algebraDefinitionFile;
    }

    public void setAlgebraDefinitionFile(AlgebraDefinitionFile algebraDefinitionFile) {
        this.algebraDefinitionFile = algebraDefinitionFile;
    }

    private static class Printer
    implements ControlFlowVisitor {
        private int indent = 0;
        private StringBuilder code = new StringBuilder();

        Printer() {
        }

        String getCode() {
            return this.code.toString();
        }

        private void appendIndent() {
            for (int i = 0; i < this.indent; ++i) {
                this.code.append('\t');
            }
        }

        @Override
        public void visit(StartNode node) {
            this.code.append("START\n");
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(AssignmentNode node) {
            this.appendIndent();
            this.code.append(node.getVariable());
            this.code.append(" = ");
            this.code.append(node.getValue());
            this.code.append(";\n");
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(StoreResultNode node) {
            this.appendIndent();
            this.code.append(node);
            this.code.append(";\n");
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(IfThenElseNode node) {
            this.appendIndent();
            this.code.append("if (");
            this.code.append(node.getCondition());
            this.code.append(") {\n");
            ++this.indent;
            node.getPositive().accept(this);
            --this.indent;
            this.appendIndent();
            this.code.append("} else {");
            ++this.indent;
            node.getNegative().accept(this);
            --this.indent;
            this.appendIndent();
            this.code.append("}\n");
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(BlockEndNode node) {
        }

        @Override
        public void visit(LoopNode node) {
            this.appendIndent();
            this.code.append("loop {\n");
            ++this.indent;
            node.getBody().accept(this);
            --this.indent;
            this.appendIndent();
            this.code.append("}\n");
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(BreakNode node) {
            this.appendIndent();
            this.code.append("break;\n");
        }

        @Override
        public void visit(Macro node) {
            this.appendIndent();
            this.code.append(node.getName());
            this.code.append(" = {\n");
            ++this.indent;
            if (node.getBody().size() > 0) {
                node.getBody().get(0).accept(this);
            }
            if (node.getReturnValue() != null) {
                this.appendIndent();
                this.code.append(node.getReturnValue());
            }
            --this.indent;
            this.appendIndent();
            this.code.append("}\n");
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(ExpressionStatement node) {
            this.appendIndent();
            this.code.append(node);
            node.getSuccessor().accept(this);
        }

        @Override
        public void visit(EndNode node) {
            this.code.append("END");
        }

        @Override
        public void visit(ColorNode node) {
            this.appendIndent();
            this.code.append(":");
            this.code.append(node);
        }
    }
}

