/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.BlockEndNode;
import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.EndNode;
import de.gaalop.cfg.Node;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;

public class IfThenElseNode
extends SequentialNode {
    private Expression condition;
    private SequentialNode positive;
    private SequentialNode negative;
    private boolean elseif;

    public IfThenElseNode(ControlFlowGraph graph, Expression condition) {
        super(graph);
        this.condition = condition;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public SequentialNode getPositive() {
        return this.positive;
    }

    public void setElseIf(boolean elseif) {
        this.elseif = elseif;
    }

    public boolean isElseIf() {
        return this.elseif;
    }

    public void setPositive(SequentialNode positive) {
        this.positive = positive;
    }

    public SequentialNode getNegative() {
        return this.negative;
    }

    public void setNegative(SequentialNode negative) {
        this.negative = negative;
    }

    @Override
    public void accept(ControlFlowVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void replaceSuccessor(Node oldSuccessor, Node newSuccessor) {
        if (oldSuccessor == this.positive) {
            newSuccessor.removePredecessor(oldSuccessor);
            newSuccessor.addPredecessor(this);
            this.setPositive((SequentialNode)newSuccessor);
        } else if (oldSuccessor == this.negative) {
            newSuccessor.removePredecessor(oldSuccessor);
            newSuccessor.addPredecessor(this);
            this.setNegative((SequentialNode)newSuccessor);
        } else {
            super.replaceSuccessor(oldSuccessor, newSuccessor);
        }
    }

    @Override
    public void replaceExpression(Expression old, Expression newExpression) {
        if (this.condition == old) {
            this.condition = newExpression;
        } else {
            this.condition.replaceExpression(old, newExpression);
        }
        this.replaceSubtree(this.positive, old, newExpression);
        if (this.negative != null) {
            this.replaceSubtree(this.negative, old, newExpression);
        }
    }

    private void replaceSubtree(Node root, Expression old, Expression newExpression) {
        if (root instanceof BlockEndNode || root instanceof EndNode) {
            return;
        }
        if (root instanceof SequentialNode) {
            root.replaceExpression(old, newExpression);
            this.replaceSubtree(((SequentialNode)root).getSuccessor(), old, newExpression);
        }
    }

    @Override
    public IfThenElseNode copyElements() {
        IfThenElseNode copy = new IfThenElseNode(this.getGraph(), this.condition.copy());
        copy.elseif = this.elseif;
        SequentialNode newPositive = this.positive.copy();
        newPositive.removePredecessor(this);
        newPositive.addPredecessor(copy);
        copy.setPositive(newPositive);
        this.copySubtree(newPositive, copy);
        SequentialNode newNegative = this.negative.copy();
        newNegative.removePredecessor(this);
        newNegative.addPredecessor(copy);
        copy.setNegative(newNegative);
        this.copySubtree(newNegative, copy);
        return copy;
    }

    private void copySubtree(SequentialNode root, SequentialNode newBase) {
        if (root instanceof BlockEndNode) {
            ((BlockEndNode)root).updateBase(newBase);
            return;
        }
        if (root.getSuccessor() instanceof SequentialNode) {
            SequentialNode successor = (SequentialNode)root.getSuccessor();
            SequentialNode newSuccessor = successor.copy();
            root.replaceSuccessor(successor, newSuccessor);
            this.copySubtree(newSuccessor, newBase);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("if(" + this.condition + ")");
        sb.append(",then={");
        SequentialNode current = this.positive;
        while (!(current instanceof BlockEndNode)) {
            sb.append(current);
            sb.append(';');
            current = (SequentialNode)current.getSuccessor();
        }
        sb.append("}");
        current = this.negative;
        if (!(current instanceof BlockEndNode)) {
            sb.append(",else={");
            while (!(current instanceof BlockEndNode)) {
                sb.append(current);
                sb.append(';');
                current = (SequentialNode)current.getSuccessor();
            }
            sb.append("}");
        }
        return sb.toString();
    }
}

