/*
 * Decompiled with CFR 0.152.
 */
package de.gaalop.cfg;

import de.gaalop.cfg.ControlFlowGraph;
import de.gaalop.cfg.ControlFlowVisitor;
import de.gaalop.cfg.SequentialNode;
import de.gaalop.dfg.Expression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Node {
    private Set<Node> predecessors = new HashSet<Node>();
    private final ControlFlowGraph graph;

    public Node(ControlFlowGraph graph) {
        this.graph = graph;
    }

    public ControlFlowGraph getGraph() {
        return this.graph;
    }

    public abstract void accept(ControlFlowVisitor var1);

    public Set<Node> getPredecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    public void addPredecessor(Node node) {
        this.predecessors.add(node);
    }

    public void removePredecessor(Node node) {
        this.predecessors.remove(node);
    }

    public abstract void replaceSuccessor(Node var1, Node var2);

    public void replaceExpression(Expression old, Expression newExpression) {
        throw new UnsupportedOperationException("Cannot replace an expression. This node type (" + this.toString() + ") does not have an expression attribute.");
    }

    public void insertBefore(SequentialNode newNode) {
        newNode.setSuccessor(this);
        HashSet<Node> predecessors = new HashSet<Node>(this.getPredecessors());
        for (Node predecessor : predecessors) {
            predecessor.replaceSuccessor(this, newNode);
        }
        predecessors.clear();
        this.addPredecessor(newNode);
    }
}

